<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/pssReports.css">

<script src="js/rgraph/RGraph.common.core.js"></script>
<script src="js/rgraph/RGraph.common.key.js"></script>
<script src="js/rgraph/RGraph.drawing.yaxis.js"></script>
<script src="js/rgraph/RGraph.drawing.xaxis.js"></script>
<script src="js/rgraph/RGraph.bar.js"></script>

<script type="text/javascript">

	$(function() {
	    $(reportTitle).focus();
	    
		var resultsTable = $('#satSurveyResultsReportTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"columnDefs": [
				{"width": "300px", "targets": 0},
				{"width": "100px", "targets": "_all"},
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : '<span tabIndex="0">No data found.</span>',
				"infoEmpty" : '<span tabIndex="0">No data found.</span>'
			}
		});
	});
	
	function questionGraph() {
		
		var dataArray = new Array();
		var monthStrings = new Array();
		<c:if test="${not empty satSurveyResultsReport && not empty satSurveyResultsReport[0]}">
			<c:if test="${fn:length(satSurveyResultsReport[0].results) > 6}">
				alert("You must select less than or equal to 6 months to display a graph.");
				return;
			</c:if>
			<c:forEach var="i" begin="0" end="${fn:length(satSurveyResultsReport[0].results) - 1}">
				monthStrings.push("${satSurveyResultsReport[0].results[i].monthAsString} ${satSurveyResultsReport[0].results[i].year}");
				var monthPercentages = new Array();
				<c:forEach var="j" begin="0" end="${fn:length(satSurveyResultsReport) - 1}">
					monthPercentages.push(${satSurveyResultsReport[j].results[i].avgAnswer * 100});
				</c:forEach>
				dataArray.push(monthPercentages);
			</c:forEach>
		</c:if>
		
		// Arbitrarily split the title, as it can grow beyond the div.
		var splitTitle = "${reportTitle}";
		var maxChars = 80;
		var count = maxChars;
		for(i = 0; i < splitTitle.length; i++) {
			if(count < 1 && splitTitle.charAt(i) == ' ') {
				splitTitle = splitTitle.substr(0,i) + '\n' + splitTitle.substr(i+1, splitTitle.length);
				count = maxChars;
			}
			count--;
		}
		
		$("#chartDialog").dialog({
			minWidth: 1050, 
			minHeight: 600
		});
		
		var keyData = new Array();
		// the questionResults.questionNumber is an Integer in the class SatisfactionSurveyQuestionResult.java, 
		// not a string thus does not expose the risk on XSS.
		<c:forEach var="questionResults" items="${satSurveyResultsReport}">
			keyData.push("Question ${questionResults.questionNumber}");
		</c:forEach>
		
		var chartColors = ['#205493', '#0071BC', '#4773AA', '#046B99', '#008682', '#027F97', '#016368', '#01866A'];
		// Draw the key first
        RGraph.HTML.Key('chartDialog', {
            labels: keyData,
            colors: chartColors,
            tableCss: {
                top: '25px',
                left: '900px',
                position: 'absolute'
            }
        });

		var bar = new RGraph.Bar({
			id: 'chart-container',
			data: dataArray,
			options: {
				noaxes: true,
				ylabels: false,
				titleY: -10,
				title: splitTitle,
				colors: chartColors,
				gutterLeft: 50,
				labelsAbove: true,
				labelsAboveOffset: -5
			}
		}).draw();
		
		var xaxis = new RGraph.Drawing.XAxis({
			id: 'chart-container',
			y: bar.canvas.height - bar.gutterBottom,
			options: {
				gutterLeft: bar.gutterLeft,
				labels: monthStrings,
				title: 'Average Response per Question per Month',
				textSize: 14
			}
		}).draw();
		
		var yaxis = new RGraph.Drawing.YAxis({
			id: 'chart-container',
			x: 50,
			options: {
				gutterTop: bar.gutterTop,
				max: 100,
				min: 0,
				scaleZerostart: true,
				title: 'Average Answer',
				textSize: 14,
				textAccessible: true
			}
		}).draw();
	}
</script>

<div id="satSurveyResultsReportContainer">
<h3 id="reportTitle"  tabIndex="0" aria-live="assertive">${reportTitle}</h3>
<table id="satSurveyResultsReportTable" tabIndex="0" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th  tabIndex="0">Question</th>
			<c:if test="${not empty satSurveyResultsReport}" >
				<c:forEach items="${satSurveyResultsReport[0].results}" var="resultMonth">
					<th  tabIndex="0">${resultMonth.monthAsString} ${resultMonth.year} ${resultMonth.modality} Patient Satisfaction Index</th> 
				</c:forEach>
			</c:if>
		</tr>
	</thead>
	<tbody>
		<c:if test="${not empty satSurveyResultsReport && not empty satSurveyResultsReport[0]}">
		<c:forEach items="${satSurveyResultsReport}" var="report">
			<tr>
				<td tabIndex="0" onclick="questionGraph()" aria-label="link to graph ${report.questionText}">${report.questionText}</td>
				<c:forEach items="${report.results}" var="monthReport" >
					<td tabIndex="0"><fmt:formatNumber type="percent" pattern="#%" value="${monthReport.avgAnswer}"/></td>
				</c:forEach>
			</tr>
		</c:forEach>
		<tr>
			<td class="lastRowBold"  tabIndex="0">${averageRow.formattedQuestionText}</td>
			<c:forEach var="i" begin="1" end="${fn:length(satSurveyResultsReport[0].results)}">
				<td class="lastRowBold"  tabIndex="0"><fmt:formatNumber type="percent" pattern="#%" value="${averageRow.results[i - 1].avgAnswer}"/></td>
			</c:forEach>
		</tr>
		<tr>
			<td class="lastRowBold"  tabIndex="0">Results as of ${currentTime}<br>
				Based on <fmt:formatNumber value="${totalSurveys}" type="number" groupingUsed="true"/>
				survey(s) received that were completed from ${dateRange}
			</td>
			<!-- Datatables does not support colspan in the body.
				We need to add extra cells to avoid Datatables errors.-->
			<c:forEach var="i" begin="1" end="${fn:length(satSurveyResultsReport[0].results)}">
				<td class="lastRowBold"  tabIndex="0"></td>
			</c:forEach>
		</tr>
		</c:if>
	</tbody>
</table>
</div>
<br>

<%@ include file="reportsMenuButton.jsp"%>

<%@ include file="pssQuestions.jsp"%>

<div id="chartDialog" style="display: none; padding: 25px">
    <canvas margin="auto" width="900px" height="400px" id="chart-container"></canvas>
</div>

<br>