<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/pssReports.css">

<script type="text/javascript">

	$(function() {
        $(reportTitle).focus();
	   
		var distributionReportResultsTable = $('#distributionReportResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"columnDefs": [
				{"width": "20%", "targets": 0},
				{"width": "15%", "targets": "_all"}
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : '<span tabIndex="0">No data found.</span>',
				"infoEmpty" : '<span tabIndex="0">No data found.</span>'
			}
		});
	})
</script>

<div id="distributionReportContainer">
<h3 id="reportTitle" tabindex="0" aria-live="assertive">${reportTitle}</h3>
<table id="distributionReportResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<c:if test="${isBreakoutRow}">
			<th tabIndex="0">${breakoutRow}</th>
			</c:if> 
			<th tabIndex="0">Vendor</th>
			<th tabIndex="0">Number of Surveys</th>
			<c:if test="${isModalityBreakoutRows}">
			<th tabIndex="0">${modalityBreakoutRowIvr}</th>
			<th tabIndex="0">${modalityBreakoutRowBrowser}</th>
			<th tabIndex="0">${modalityBreakoutRowHomeDevice}</th>
			</c:if> 
				
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${report.report}" var="report">
			<tr>
				<c:if test="${isBreakoutRow}">
				<td tabIndex="0">${report[0]}</td>
				</c:if>
				
				<td tabIndex="0">${report[1]}</td>
				<td tabIndex="0"><fmt:formatNumber value="${report[2]}" type="number" groupingUsed="true"/></td>
				
				<c:if test="${isModalityBreakoutRows}">
				<td tabIndex="0"><fmt:formatNumber value="${report[3]}" type="number" groupingUsed="true"/></td>
				<td tabIndex="0"><fmt:formatNumber value="${report[4]}" type="number" groupingUsed="true"/></td>
				<td tabIndex="0"><fmt:formatNumber value="${report[5]}" type="number" groupingUsed="true"/></td>
				</c:if>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br>
<%@ include file="reportsMenuButton.jsp"%>
<br>
<%@ include file="pssQuestions.jsp"%>