<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/manageusers.css">
<link rel="stylesheet" href="css/userregistration.css">
<script type="text/javascript" src="js/manageUser.js"></script>


<form:form method="post" action="manageUsersEdit.html"  commandName="command">

<div id="error">
	<h4 style="color:red" tabindex="0">Error Message(s):</h4>
	<ul>
		<li id='visnRequiredMessage' tabindex="1"> <span tabindex="0">VISN is required.</span></li>
		<li id='facilityRequiredMessage' tabindex="1"> <span tabindex="0">Facility is required.</span></li>
		<li id='inactivateReasonRequiredMessage' tabindex="1"> <span tabindex="0">Inactive Reason is required.</span></li>
		<li id='inactivateDateRequiredMessage' tabindex="1"> <span tabindex="0">Inactive Date is required.</span></li>
		<li id='roleRequiredMessage' tabindex="1"> <span tabindex="0">Role is required.</span></li>
		<li id='vendorRequiredMessage' tabindex="1"> <span tabindex="0">Vendor is required.</span></li>
		<li id='registrationDeniedRequiredMessage' tabindex="1"> <span tabindex="0">Registration Denied Reason is required.</span></li>
		
		<li id='assignedVisnMustMatchAssignedFacilityVisnMessage' tabindex="1"> <span tabindex="0">Assigned VISN must match the Assigned Facilities VISN.</span></li>
	</ul>
</div>

<div id="userName">
	<label tabIndex="0" class="ihtaLabel">User Name: <span class="detailInfo"><c:out value="${command.familyName}" />, <c:out
			value="${command.givenName}" /></span> </label>
</div>
<div id="userId">
	<label tabIndex="0" class="ihtaLabel">User ID: <span class="detailInfo"><c:out value="${command.userName}" /></span></label>
	
</div>
<div id="email">
	<label tabIndex="0" class="ihtaLabel">E-mail: <span class="detailInfo"><c:out value="${command.email}" /></span></label>
	
</div>
<div id="phone">
	<label tabIndex="0" class="ihtaLabel">Phone: <span class="detailInfo"><c:out value="${command.telephoneNumber}" /></span></label>
	
</div>

<div id="userGroupContainer">
	<label tabIndex="0" class="ihtaLabel">User Group: <span class="detailInfo"><c:out value="${command.userGroup.label}" /></span></label>
	
</div>

<div id="registrationStatusContainer">
	<label tabIndex="0" class="ihtaLabel">Registration Status: <span class="detailInfo"><c:out value="${command.registrationStatus.label}" /></span></label>
</div>	

<c:choose>
	<c:when test="${showRegistrationDenied && !disableRegDeniedDropdown}">
		<div id="registrationDeniedContainer">
		<label tabIndex="0" class="ihtaLabel">Registration Denied Reason:</label>
			<c:choose>				
				<c:when test="${canEdit && (isCurrentUserAppAdmin == false)}">
					<h2 class="required">*</h2>
					<form:select id="assignedRegistrationDenied"
						path="registrationDeniedReasonId"
						items="${registrationDeniedReasons}"  alt="Registration denied reason required field">
					</form:select>
				</c:when>
				<c:otherwise>
					<label tabIndex="0" class="ihtaLabel">Registration Denied Reason: <span class="detailInfo"><c:out value="${command.registrationDeniedReason.label}" /></span></label>					
				</c:otherwise>	
			</c:choose>
		</div>
	</c:when>
	<c:when test="${disableRegDeniedDropdown}">
		<div id="registrationDeniedContainer">
			<label tabindex="0" class="ihtaLabel">Registration Denied Reason: <span class="detailInfo"><c:out value="${command.registrationDeniedReason.label}" /></span></label>					
		</div>
	</c:when>
</c:choose>

<div id="jobDescriptionContainer">
	<label tabIndex="0" class="ihtaLabel">Job Description: <span class="detailInfo"><c:out value="${command.registrationReason.label}" /></span></label>
</div>

<div id="availableRoles">
<h4 tabIndex="0" style="opacity:0; width:0px;">Roles: At least one role is required</h4>
<label tabIndex="1" class="ihtaLabel" style="margin-left:-250px;" title="Roles: At least one role is required">Roles:</label>
<h2 class="required" >*</h2>
	<c:forEach var="role" items="${rolesMap}">
		<span> <c:choose>
				<c:when test="${role.value}">
					<form:checkbox name="selectedRoles" checked="checked"
						path="selectedRoles" value="${role.key}" id="${role.key}" />
				</c:when>
				<c:otherwise>
					<form:checkbox name="selectedRoles" path="selectedRoles" value="${role.key}"
						id="${role.key}" />
				</c:otherwise>
			</c:choose> <label for="${role.key}">${role.key}</label>
		</span>
	</c:forEach>
</div>

<div id="assignedVisnContainer">
<label tabIndex="0" class="ihtaLabel">Assigned VISN: </label>
	<c:choose>			
		<c:when test="${canEdit && (isCurrentUserAppAdmin == false)}"> 
			<h2 class="required">*</h2>
			<form:select id="assignedVisnIdSelect" path="assignedVisnId" items="${visns}">
				<option value="0">Select VISN</option>
			</form:select>
		</c:when>
		<c:otherwise>
			<span class="detailInfo"><c:out value="${command.visn.label}" /></span>
		</c:otherwise>	
	</c:choose>
</div>

<div id="assignedFacilityContainer">	
<label tabIndex="0" class="ihtaLabel">Assigned Facility: </label>
	<c:choose>
		<c:when test="${canEdit && (isCurrentUserAppAdmin == false)}"> 
			<h2 class="required">*</h2>
			<form:select id="assignedFacilityIdSelect" path="assignedFacilityId" items="${facilities}">
			</form:select>
		</c:when>
		<c:otherwise>
			<span class="detailInfo"><c:out value="${command.facility.label}" /></span>
		</c:otherwise>	
	</c:choose>
</div>

<div id="vendor">
<label tabIndex="0" class="ihtaLabel">Vendor: </label>
	<c:choose>
		<c:when test="${canEdit  && (isCurrentUserAppAdmin == false)}"> 
			<h2 class="required">*</h2>
			<form:select id="assignedVendorIdSelect" path="assignedVendorId" items="${vendors}">
			</form:select>
		</c:when>
		<c:otherwise>
			<span class="detailInfo"><c:out value="${command.vendor.label}" /></span>		
		</c:otherwise>	
	</c:choose>	
</div>

<div id="lockedContainer">
	<label tabIndex="0" class="ihtaLabel">Locked: </label>	
	<c:choose>
		<c:when test="${canEdit || isCurrentUserAppAdmin}">
			<form:checkbox path="locked" id="locked" title="locked"/>
		</c:when>
		<c:otherwise>
			<form:checkbox path="locked" id="locked" disabled="true" title="locked"/>
		</c:otherwise>
	</c:choose>		
</div>

<div id="inactivate">

	<label tabIndex="0" class="ihtaLabel">Inactivate: </label>
	
		<c:choose>
			<c:when test="${canEdit && !isCurrentUserAppAdmin}">
				<form:checkbox path="inactive" id="inactive" title="inactive"/>
			</c:when>
			<c:otherwise>
				<form:checkbox path="inactive" id="inactive" disabled="true" title="inactive"/>
			</c:otherwise>
		</c:choose>
		<c:choose>
			<c:when test="${canEdit && !isCurrentUserAppAdmin}">
				<div id="inactivateDate">
					<label tabIndex="0" class="ihtaLabel">Inactivation Date: </label>	
					<h2 class="required">* </h2> 
					<form:input id="datepicker" path="inactivationDateAsString" title="Please enter a date in dd/mm/yyyy format required field"/>
					
				</div>
				<div id="inactivateReason">
					<label tabIndex="0" class="ihtaLabel">Inactivation Reason: </label>
					<h2 class="required">* </h2> 
					<form:select id="inactiveReasonId" path="inactiveReasonId"
					items="${inactiveReasons}"  title="Inactive reason required field">
					</form:select>	
				</div>
			</c:when>
			<c:otherwise>
				<div id="disabledInactivateDate">
					<label tabIndex="0" class="ihtaLabel">Inactivation Date: </label> 
					<form:input id="datepicker" path="inactivationDateAsString" disabled="true"/>
				</div>
				<div id="disabledInactivateReason">
					<label tabIndex="0" class="ihtaLabel">Inactivation Reason: </label> 
					<form:select id="inactiveReasonId" path="inactiveReasonId" 	items="${inactiveReasons}" disabled="true">
					</form:select>
				</div>
			</c:otherwise>
		</c:choose>
</div>

<div id="buttonContainer">

	<c:choose>
		<c:when test="${canEdit || isCurrentUserAppAdmin}">
			<input type="submit" class="button" title="Submit" id="submit" value = "Submit" onclick="return(validate())" tabIndex="0"/>
			<input type="submit" class="button" title="Reset" name="Reset" id="reset" value = "Reset" tabIndex="0"/>
			<input type="button" class="button" title="Cancel" value="Cancel" onclick="javascript:confirmCancel();" />
		</c:when>
		<c:otherwise>
			<input type="button" class="button" title="Cancel" value="Cancel" onclick="javascript:confirmCancel();" />
		</c:otherwise>
	</c:choose>
	
</div>

<input type="hidden" id="isCurrentUserAppAdmin" value="${isCurrentUserAppAdmin}">
<input type="hidden" id="isNationalAdmin" value="${isNationalAdmin}">
<input type="hidden" id="isAppAdmin" value="${isApplicationAdmin}">
<input type="hidden" id="isCareCoordinator" value="${isCareCoordinator}">
<input type="hidden" id="isFacilityAdmin" value="${isFacilityAdmin}">
<input type="hidden" id="disableRegDeniedDropdown" value="${disableRegDeniedDropdown}">
<input type="hidden" id="isOTS" value="${isOTS}">
<input type="hidden" id="isPSA" value="${isPSA}">
<input type="hidden" id="isQIR" value="${isQIR}">
<input type="hidden" id="isDeny" value="${isDeny}">
<input type="hidden" id="isReportsOnly" value="${isReportsOnly}">
<input type="hidden" id="isVendor" value="${isVendor}">
<input type="hidden" id="isVisnAdmin" value="${isVisnAdmin}">
<input type="hidden" id="isManagement" value="${management}">
<input type="hidden" id="canEditPage" value="${canEdit}">
<input type="hidden" id="assignedFacilitiesVisnId" value="${assignedFacilitiesVisnId}">
<input type="hidden" id="assignedVisnId" value="${assignedVisnId}">
<input type="hidden" id="showRoles" value="${showRoles}">
<input type="hidden" id="returnPage" value="${fn:escapeXml(command.returnPage)}">

<form:hidden path="userName"/>
<form:hidden path="fromPage"/>
<form:hidden path="returnPage"/>

</form:form>
