<%@ include file="inc_header.jsp"%>

<script type="text/javascript">
	function showErrors(allErrors) {
		$("#errorsWrapper").toggle(allErrors && allErrors.length > 0)
		
		$("#errorList").empty()
		for (var i = 0; i < allErrors.length; i++) {
			var error = allErrors[i]			
			var msg = '<li class="error" tabindex="0"><span>' + error.message + '</span></li>'
			$("#errorList").append($(msg))
			$('input[name="' + error.field + '"]').css('border', '1px solid red')
			$('textarea[name="' + error.field + '"]').css('border', '1px solid red')
			$('select[name="' + error.field + '"]').css('border', '1px solid red')
		}
	}

	function hideErrors() {
		$("#errorsWrapper").hide()
	}
</script>

<spring:hasBindErrors name="command">
	<c:set var="hasErrors" scope="request" value="${errors.errorCount > 0}" />
	<c:if test="${hasErrors}">
		<script type="text/javascript">
			$(function() {
				var allErrors = []
				<c:forEach var="error" items="${errors.allErrors}">
				allErrors
						.push({
							field : "<c:out value="${error.field}" />",
							message : "<spring:message code="${error.code}" text="${error.defaultMessage}" arguments="${error.arguments}" />"
						})
				</c:forEach>
				showErrors(allErrors)
			})
		</script>
	</c:if>
</spring:hasBindErrors>

<div id="errorsWrapper" class="errorBlock error" style="display:none">
	<span class="error" tabindex="0">Error Message(s):</span>
	<ul id="errorList">
		<c:forEach var="error" items="${errors.allErrors}">
			<li class="error" tabindex="0"><span tabindex="0"></span></li>
		</c:forEach>
	</ul>
</div>
