<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">

	$(function() {
        $(reportTitle).focus();
        
		var catOfCareTotalsResultsTable = $('#catOfCareTotalsResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : '<span tabIndex="0">No data found.</span>',
				"infoEmpty" : '<span tabIndex="0">No data found.</span>'
			}
		});
		
	})
</script>

<div id="catOfCareResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="catOfCareTotalsResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th aria-label="${firstRowLabel}" tabindex="0">${firstRowLabel}</th>
			<th aria-label="Non-institutional Care (NIC)" tabindex="0">Non-institutional Care (NIC)</th> 
				<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
					<th aria-label="Non-institutional Care (NIC) Percent" tabindex="0">Non-institutional Care (NIC) Percent</th>
				</c:if>
			<th aria-label="Non-Institutional Care Low Responder (NICLR)" tabindex="0">Non-Institutional Care Low Responder (NICLR)</th>
				<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
					<th aria-label="Non-Institutional Care Low Responder (NICLR) Percent" tabindex="0">Non-Institutional Care Low Responder (NICLR) Percent</th>
				</c:if>
			<th aria-label="Chronic Care Management" tabindex="0">Chronic Care Management</th>
				<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
					<th aria-label="Chronic Care Management Percent" tabindex="0">Chronic Care Management Percent</th>
				</c:if>
			<th aria-label="Acute Care Management" tabindex="0">Acute Care Management</th>
				<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
					<th aria-label="Acute Care Management Percent" tabindex="0">Acute Care Management Percent</th>
				</c:if>
			<th aria-label="Health Promotion/Disease Prevention" tabindex="0">Health Promotion/Disease Prevention</th>
				<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
					<th aria-label="Health Promotion/Disease Prevention Percent" tabindex="0">Health Promotion/Disease Prevention Percent</th>
				</c:if>
			<th aria-label="L2 - Low Acuity/ Low Intensity" tabindex="0">L2 - Low Acuity/ Low Intensity</th>
				<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
					<th aria-label="L2 - Low Acuity/ Low Intensity Percent" tabindex="0">L2 - Low Acuity/ Low Intensity Percent</th>
				</c:if>
			<th aria-label="Totals" tabindex="0">Totals</th>
		</tr>
	</thead>
	<tbody>
	<c:if test="${dataPresent}">
	<!-- Vendor Totals Row, has some different Columns, must be done seperetly  -->
		<c:forEach begin="0" end="${vendorReportsSize}" items="${categoryOfCareReport}" var="report">
			<tr>
				<td tabindex="0">
					<c:choose>
						<c:when test="${visnReport}">
							<form:form method="post" action="reports.html" commandName="form" class="inline">
							<input type="hidden" name="cocDrillDownVisn" value="true"/>
							<form:hidden path="visnId" value="${report.visnId}"/>
							<form:hidden path="vendorId" value="${vendorId}"/>
							<form:hidden path="reportEndDate" value="${reportEndDate}"/>
                            <form:hidden path="buttonSelection" value="${buttonSelection}"/>
							<form:hidden path="originalReportVisnId" value="${originalReportVisnId}"/>
                            <form:hidden path="showVendorSubtotals" value="${showVendorSubtotals}"/>
							<button type="submit" value="Submit" class="link-button">
							${report.name}</button>
							</form:form>
						</c:when>
						<c:otherwise>
							${report.name}
						</c:otherwise>
					</c:choose>
				</td>
				<td tabindex="0"><fmt:formatNumber value="${report.nic}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
						<td tabindex="0"><fmt:formatNumber value="${report.nicPercent}" type="percent" minFractionDigits="2"/></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${report.niclr}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
						<td tabindex="0"><fmt:formatNumber value="${report.niclrPercent}" type="percent" minFractionDigits="2"/></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${report.chronicCareMgnt}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
						<td tabindex="0"><fmt:formatNumber value="${report.chronicCareMgntPercent}" type="percent" minFractionDigits="2"/></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${report.acuteCareMgnt}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
						<td tabindex="0"><fmt:formatNumber value="${report.acuteCareMgntPercent}" type="percent" minFractionDigits="2"/></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${report.hpdp}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
						<td tabindex="0"><fmt:formatNumber value="${report.hpdpPercent}" type="percent" minFractionDigits="2"/></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${report.lowActLowInt}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}"> <!-- Only for VISN and FACILITY -->
						<td tabindex="0"><fmt:formatNumber value="${report.lowActLowIntPercent}" type="percent" minFractionDigits="2"/></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${report.total}" type="number" groupingUsed="true"/></td>
			</tr>
	<!-- Percents Row, has different Columns, must be done separtly  -->
		</c:forEach>
			<tr>
				<td tabindex="0">${categoryOfCareReport[vendorReportsSize+1].rowName}</td>
				<td tabindex="0"><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].nic}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].niclr}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].chronicCareMgnt}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].acuteCareMgnt}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].hpdp}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].lowActLowInt}" type="number" groupingUsed="true"/></td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0">${categoryOfCareReport[vendorReportsSize+1].columnName}</td>
			</tr>
			<tr>
				<td tabindex="0">${categoryOfCareReport[vendorReportsSize+2].rowName}</td>
				<td tabindex="0">
					<fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+2].nicPercentTotal}" type="percent" minFractionDigits="2"/>
				</td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0">
					<fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+2].niclrPercentTotal}" type="percent" minFractionDigits="2"/>
				</td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0"><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+2].chronicCareMgntPercentTotal}" type="percent" minFractionDigits="2"/></td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0">
					<fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+2].acuteCareMgntPercentTotal}" type="percent" minFractionDigits="2"/>
				</td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0">
					<fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+2].hpdpPercentTotal}" type="percent" minFractionDigits="2"/>
				</td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
				<td tabindex="0" >
					<fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+2].lowActLowIntPercentTotal}" type="percent" minFractionDigits="2"/>
				</td>
					<c:if test="${showPercentColumns}">
						<td></td>
					</c:if>
 				<td tabindex="0">
 					<fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+2].totalsTotal}" type="number" groupingUsed="true"/>
 				</td>
 			</tr>
 		</c:if>
	</tbody>
</table>
</div>
<br>
 <table role="presentation" style="margin-left: auto; margin-right: auto">
	 <tr>
		 <c:if test="${backButton}">
		    <td>
		       <%@ include file="censusReportsVisnReturnButton.jsp"%>
		    </td>
		</c:if>
		<td>
		    <%@ include file="reportsMenuButton.jsp"%>
		</td>
	</tr>
</table>
<%@ include file="vendorReportStatus.jsp"%>
<%@ include file="cocNICMessage.jsp"%>
