package gov.va.med.fw.validation;

// Java classes
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.util.StringUtils;

/**
 * A class that encapsulates messages. Messages can be either global or they are
 * specific to a particular bean property.
 * 
 * @author Muddaiah Ranga
 * @version 3.o
 */
public class ValidationMessages implements Serializable {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -188887558399147920L;

	protected List list = Collections.synchronizedList(new ArrayList());

	/**
	 * Create an empty ValidationMessages object.
	 */
	public ValidationMessages() {
		super();
	}

	/**
	 * Adds the ValidationMessage to the list of validation messages.
	 * 
	 * @param message
	 *            the validation message.
	 */
	public void add(ValidationMessage message) {
		if (message != null) {
			list.add(message);
		}
	}

	/**
	 * Adds the ValidationMessages to the list of validation messages.
	 * 
	 * @param message
	 *            the validation message.
	 */
	public void add(ValidationMessages messages) {

		if (messages != null && !messages.isEmpty()) {
			for (Iterator i = messages.get(); i.hasNext();) {
				ValidationMessage message = (ValidationMessage) i.next();
				this.add(message);
			}
		}
	}

	/**
	 * Adds the ValidationMessages to the list of validation messages and sets
	 * indentifier.
	 * 
	 * @param message
	 *            the validation message.
	 * @param identifier
	 *            an identifier
	 */
	public void add(ValidationMessages messages, String identifier) {

		if (messages != null && !messages.isEmpty()) {
			for (Iterator i = messages.get(); i.hasNext();) {
				ValidationMessage message = (ValidationMessage) i.next();
				if (StringUtils.isNotEmpty(identifier)) {
					message.setIdentifier(identifier);
				}
				this.add(message);
			}
		}
	}

	/**
	 * Gets an Iterator to the list of validation messages.
	 */
	public Iterator get() {
		return list.iterator();
	}

	/**
	 * Gets the total number of validation messages.
	 */
	public int getCount() {
		return list.size();
	}

	/**
	 * Removes all the validation messages in the list.
	 */
	public void clear() {
		list.clear();
	}

	/**
	 * Checks to see if the list of validation messages is empty.
	 */
	public boolean isEmpty() {
		return (list.isEmpty());
	}

	public String getAllMessageText() {

		StringBuilder info = new StringBuilder();
		for (int i = 0; i < getCount(); i++) {
			info.append("Message Key: ").append(((ValidationMessage) list.get(i)).getKey());
		}
		return info.toString();
	}

	/**
	 * Find a ValidationMessage with a given message key. If there are multiple
	 * messages with the same key, first one is returned.
	 * 
	 * @param key
	 * @return ValidationMessage or null if no message with a given key exists.
	 */
	public ValidationMessage find(String key) {
		Validate.notNull(key, "Message key is required");
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			ValidationMessage valMsg = (ValidationMessage) iter.next();
			if (key.equals(valMsg.getKey())) {
				return valMsg;
			}
		}
		return null;
	}

	/**
	 * Return whether or not a message with a given key exists.
	 * 
	 * @param key
	 * @return true if message exists, false otherwise.
	 */
	public boolean contains(String key) {
		return find(key) != null;
	}
}
