package gov.va.med.fw.validation;

import java.io.Serializable;

/**
 * This class is a representation of a validation message.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class ValidationMessage implements Serializable {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8233149159067035381L;

	// Entity identifier
	protected String identifier;

	// The message key for this message.
	protected String key;

	// Replacement values for this messageReplacement parameter values.
	protected Object values[] = null;

	// Generic bucket for Context info
	private Object contextInfo;

	/**
	 * Construct an action message with no replacement values.
	 * 
	 * @param key
	 *            Message key for this message
	 */
	public ValidationMessage(String key) {
		this(key, null);
	}

	/**
	 * Construct an action message with the specified replacement values.
	 * 
	 * @param key
	 *            Message key for this message
	 * @param value0
	 *            First replacement value
	 */
	public ValidationMessage(String key, Object value0) {
		this(key, new Object[] { value0 });
	}

	/**
	 * Construct an action message with the specified replacement values.
	 * 
	 * @param key
	 *            Message key for this message
	 * @param value0
	 *            First replacement value
	 * @param value1
	 *            Second replacement value
	 */
	public ValidationMessage(String key, Object value0, Object value1) {
		this(key, new Object[] { value0, value1 });
	}

	/**
	 * Construct an action message with the specified replacement values.
	 * 
	 * @param key
	 *            Message key for this message
	 * @param value0
	 *            First replacement value
	 * @param value1
	 *            Second replacement value
	 * @param value2
	 *            Third replacement value
	 */
	public ValidationMessage(String key, Object value0, Object value1, Object value2) {
		this(key, new Object[] { value0, value1, value2 });
	}

	/**
	 * Construct an action message with the specified replacement values.
	 * 
	 * @param key
	 *            Message key for this message
	 * @param value0
	 *            First replacement value
	 * @param value1
	 *            Second replacement value
	 * @param value2
	 *            Third replacement value
	 * @param value3
	 *            Fourth replacement value
	 */
	public ValidationMessage(String key, Object value0, Object value1, Object value2, Object value3) {
		this(key, new Object[] { value0, value1, value2, value3 });
	}

	/**
	 * Construct an action message with the specified replacement values.
	 * 
	 * @param key
	 *            Message key for this message
	 * @param values
	 *            Array of replacement values
	 */
	public ValidationMessage(String key, Object[] values) {
		this.key = key;
		this.values = values;
	}

	/**
	 * Gets the entity identifier.
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * Sets the entity identifier.
	 */
	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	/**
	 * Get the message key for this message.
	 */
	public String getKey() {
		return (this.key);
	}

	/**
	 * Get the replacement values for this message.
	 */
	public Object[] getValues() {
		return (this.values);
	}

	/**
	 * Returns a String in the format: key[value1, value2, etc].
	 */
	public String toString() {
		StringBuilder buff = new StringBuilder();
		buff.append(this.key);
		buff.append("[");

		if (this.values != null) {
			for (int i = 0; i < this.values.length; i++) {
				buff.append(this.values[i]);
				// don't append comma to last entry
				if (i < this.values.length - 1) {
					buff.append(", ");
				}
			}
		}
		buff.append("]");
		return buff.toString();
	}

	/**
	 * @return Returns the contextInfo.
	 */
	public Object getContextInfo() {
		return contextInfo;
	}

	/**
	 * @param contextInfo
	 *            The contextInfo to set.
	 */
	public void setContextInfo(Object contextInfo) {
		this.contextInfo = contextInfo;
	}
}
