/********************************************************************
 Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.builder;

// Java Classes
import java.io.Serializable;

/**
 * Provides a generic interface to encapsulate how an object is validated.
 * 
 * @author Vu Le
 * @version 1.0
 * @since 1.0
 */
public interface Validator extends Serializable {

	/**
	 * Validates a raw object's data to ensure its contents are valid
	 * 
	 * @param input
	 *            A raw object to be validated
	 * @throws ValidatorException
	 *             Thrown if failed to validate an object
	 */
	public void validate(Object input) throws ValidatorException;
}