/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util;

import java.io.IOException;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

import gov.va.med.ccht.ui.interceptor.CommonReferenceDataInterceptor;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

/**
 * CISS ciss_common July 29, 2008
 * 
 * @author Muddaiah Ranga
 */
@Component
public class VersionInfo extends AbstractComponent implements InitializingBean{
	
	private static final Logger logger = LoggerFactory.getLogger(VersionInfo.class);
	
	@Value("env/cchtversion.properties")
	private String versionPropsLocation;
	
	private Properties versionProperties;
	
	@Override
	public void afterPropertiesSet() throws IOException {
		PropertiesFactoryBean factory = new PropertiesFactoryBean();
		factory.setLocation(new ClassPathResource(versionPropsLocation));
		factory.afterPropertiesSet();
		versionProperties = factory.getObject();
	}

	public String getVersion() throws ServiceException {
		StringBuilder version = new StringBuilder();
		if (versionProperties != null) {
			version.append(versionProperties.getProperty("major.rel.num"));
			version.append(".");
			version.append(versionProperties.getProperty("minor.rel.num"));
			version.append(".");
			version.append(versionProperties.getProperty("patch.rel.num"));
			version.append(".");
			version.append(versionProperties.getProperty("sqa.num"));
			version.append(versionProperties.getProperty("build.num"));
		}
		return version.toString();
	}

	public Properties getVersionProperties() {
		return versionProperties;
	}

	public void setVersionProperties(Properties versionProperties) {
		this.versionProperties = versionProperties;
	}
}
