/********************************************************************
 Copyriight 2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util;

// Library Classes
import java.io.Serializable;

import org.apache.commons.lang.StringUtils;

/**
 * A bean that contains a sort column (e.g. GUI column, database column, etc.)
 * and direction.
 * 
 * @author Andrew Pach
 * @version 3.0
 */
public class SortElement implements Serializable {
	private static final long serialVersionUID = 2511990436529594779L;

	/**
	 * Constant for a descending order.
	 */
	public static final String DESCENDING = "desc";

	/**
	 * Constant for an ascending order.
	 */
	public static final String ASCENDING = "asc";

	/**
	 * The sort column.
	 */
	private String sortColumn = null;

	/**
	 * The sort direction. Should be one of ASCENDING or DESCENDING. Default:
	 * ASCENDING.
	 */
	private String sortDirection = ASCENDING;

	/**
	 * Constructs a SortElement.
	 * 
	 * @param sortColumn
	 *            The sort column.
	 * @param sortDirection
	 *            The sort direction.
	 */
	public SortElement(String sortColumn, String sortDirection) {
		setSortColumn(sortColumn);
		setSortDirection(sortDirection);
	}

	/**
	 * Sets the sort column.
	 * 
	 * @param sortColumn
	 *            The sort column
	 */
	public void setSortColumn(String sortColumn) {
		this.sortColumn = sortColumn;
	}

	/**
	 * Gets the sort column
	 * 
	 * @return The sort column
	 */
	public String getSortColumn() {
		return sortColumn;
	}

	/**
	 * Sets the sort direction. This should be either ASCENDING or DESCENDING.
	 * If an invalid value is entered, ASCENDING will be used.
	 * 
	 * @param sortDirection
	 *            The sort direction.
	 */
	public void setSortDirection(String sortDirection) {
		if ((sortDirection != null) && (sortDirection.equals(DESCENDING))) {
			this.sortDirection = DESCENDING;
		} else {
			this.sortDirection = ASCENDING;
		}
	}

	/**
	 * Gets the sort direction.
	 * 
	 * @return The sort direction.
	 */
	public String getSortDirection() {
		return sortDirection;
	}

	/**
	 * Determines whether this object's sort column is equals to the passed in
	 * object's sort column.
	 * 
	 * @param object
	 *            Another sort element object
	 * 
	 * @return True if the sort columns are the same or false if not.
	 */
	public boolean hasSameSortColumn(Object object) {
		SortElement sortElement = (SortElement) object;
		if (StringUtils.equals(sortColumn, sortElement.sortColumn)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Determines whether this object's sort direction is equals to the passed
	 * in object's sort direction.
	 * 
	 * @param object
	 *            Another sort element object
	 * 
	 * @return True if the sort directions are the same or false if not.
	 */
	public boolean hasSameSortDirection(Object object) {
		SortElement sortElement = (SortElement) object;
		if (StringUtils.equals(sortDirection, sortElement.sortDirection)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * @see java.lang.Object#equals
	 */
	public boolean equals(Object object) {
		SortElement sortElement = (SortElement) object;
		if ((StringUtils.equals(sortColumn, sortElement.sortColumn))
				&& (StringUtils.equals(sortDirection, sortElement.sortDirection))) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * @see java.lang.Object#toString
	 */
	public String toString() {
		return "Sort Column: " + sortColumn + ", Sort Direction: " + sortDirection;
	}
}