/********************************************************************
 * Copyriight 2007 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.util;

import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.lang.Validate;
import org.springframework.stereotype.Component;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Initial javadoc for class EncoderDecoderUtil. TODO - Add content here
 * 
 * Created Apr 18, 2007 2:59:33 PM
 * 
 * DNS
 */
@Component
public class EncoderDecoderUtil extends AbstractComponent {
	private BinaryEncoder encoder;
	private BinaryDecoder decoder;
	
	public EncoderDecoderUtil() {
		encoder = new org.apache.commons.codec.binary.Base64();
		decoder = new org.apache.commons.codec.binary.Base64();
	}

	public String encode(byte[] rawData) {
		try {
			return new String(encoder.encode(rawData));
		} catch (EncoderException e) {
			throw new IllegalArgumentException("Unable to encode argument: " + rawData);
		}
	}

	public byte[] decode(String encodedData) {
		try {
			return decoder.decode(encodedData.getBytes());
		} catch (DecoderException e) {
			throw new IllegalArgumentException("Unable to decode argument: " + encodedData);
		}
	}

	public BinaryDecoder getDecoder() {
		return decoder;
	}

	public void setDecoder(BinaryDecoder decoder) {
		this.decoder = decoder;
	}

	public BinaryEncoder getEncoder() {
		return encoder;
	}

	public void setEncoder(BinaryEncoder encoder) {
		this.encoder = encoder;
	}

	public void afterPropertiesSet() {
		Validate.notNull(encoder, "encoder is null");
		Validate.notNull(decoder, "decoder is null");
	}
}
