/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.ui.filter;

// Java classes
import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.fw.service.AbstractComponent;

/**
 * This represents a general framework for input filtering. It provides basic
 * functionality for general filter. All derived filter (for a specific task)
 * will provide appropriate implementation of doFilter(...) method for handling
 * specific input type.
 */
public abstract class BaseFilter extends AbstractComponent implements Filter {
	protected Log logger = LogFactory.getLog(getClass());
	private ServletContext context = null;

	/**
	 * A default constructor for the filter.
	 */
	protected BaseFilter() {
		super();
	}

	/**
	 * This method performs the specific task of handling input in a desired
	 * way. Each filter, after handling the input itself, will pass the input to
	 * the next filter in the chain for further input processing. All derived
	 * filters must provide a specific implementation of this method.
	 * 
	 * @param request
	 *            The input information contained in ServletRequest object.
	 * @param response
	 *            The outgoing data container in ServletResponse object.
	 * @param chain
	 *            The filter chain containing all the filters for a particular
	 *            group of activities.
	 * @throws IOException
	 *             When input retrieval encounters problem.
	 * @throws ServletException
	 *             To indicate problems in servlet parameters and its behavior.
	 */
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		chain.doFilter(request, response);
	}

	/**
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
		logger = null;
	}

	/**
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig config) throws ServletException {
		context = config.getServletContext();
	}

	public ServletContext getServletContext() {
		return context;
	}
}
