// Created Apr 27, 2005 4:40:41 PM

/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.trigger;

import java.util.Set;

/**
 * Any application component that can trigger events needs to implement this
 * interface and manage the set of TriggerEvents.
 * 
 * @author DNS   
 */
public interface TriggerAware {
	/**
	 * Returns the TriggerEvents that were created via addTriggerEvent, without
	 * duplicates
	 */
	public Set getTriggerEvents();

	/** Adds a TriggerEvent for processing */
	public void addTriggerEvent(TriggerEvent triggerEvent);

	/** Callback to clear storage of TriggerEvent's */
	public void clearTriggerEvents();
}
