/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;

import gov.va.med.fw.model.ldap.LdapPerson;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.persistent.ldap.LdapGroupDao;
import gov.va.med.fw.persistent.ldap.LdapPersonDao;

/**
 * Service Implementation for LdapPerson.
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author DNS
 */
@Service
public class LdapPersonServiceImpl implements LdapPersonService {
	
	@Autowired
	private LdapPersonDao personDao;
	@Autowired
	private LdapGroupDao groupDao;

	public LdapPerson findByDistinguishedName(String dn) {
		return personDao.findByDistinguishedName(dn);
	}

	public List findAll() {
		return personDao.findAll();
	}

	public List find(SearchCriteria criteria) {
		return personDao.find(criteria);
	}

	public LdapPerson findBySamAccountName(String sAMAccountName) {
		return personDao.findBySamAccountName(sAMAccountName);
	}

	public void setPersonDao(LdapPersonDao personDao) {
		this.personDao = personDao;
	}

	public void setGroupDao(LdapGroupDao groupDao) {
		this.groupDao = groupDao;
	}

	public boolean authenticate(String userDn, String password) {
		return personDao.authenticate(userDn, password);
	}

	/**
	 * The updateGroups method adds and removes an ldapPerson from specified
	 * ldapGroups by modifying the members attribute of each group. Note that a
	 * group's CN must be the same as it's sAMAccountName.
	 * 
	 * @param ldapPerson
	 *            The ldapPerson to be removed or added to LdapGroups.
	 */
//	public void updateGroups(LdapPerson ldapPerson) {
//		// Delete person from groups
//		for (Iterator i = ldapPerson.getDeletedGroups().iterator(); i.hasNext();) {
//			String cnToRemove = (String) i.next();
//			LdapGroup groupToDelete = groupDao.findByDistinguishedName(cnToRemove);
//			groupToDelete.getMembers().remove(ldapPerson.getDn());
//			groupDao.update(groupToDelete);
//		}
//
//		// Add person to groups
//		for (Iterator i = ldapPerson.getNewGroups().iterator(); i.hasNext();) {
//			String cnToAdd = (String) i.next();
//			LdapGroup groupToAdd = groupDao.findByDistinguishedName(cnToAdd);
//			groupToAdd.getMembers().add(ldapPerson.getDn());
//			groupDao.update(groupToAdd);
//		}
//	}

	/*
	 * (non-Javadoc)
	 * 
	 * @seeorg.springframework.security.ldap.LdapAuthoritiesPopulator#
	 * getGrantedAuthorities(org.springframework.ldap.core.DirContextOperations,
	 * java.lang.String)
	 */
	public Collection<GrantedAuthority> getGrantedAuthorities(DirContextOperations user, String username) {
		LdapPerson ldapPerson = findBySamAccountName(username);
		// convert roles to Granted Authorities
		if (ldapPerson != null && ldapPerson.getGroups() != null) {
			Collection<GrantedAuthority> roles = new ArrayList<GrantedAuthority>();
			int location = 0;
			for (Object role : ldapPerson.getGroups()) {
				GrantedAuthority authority = new SimpleGrantedAuthority((String) role);
				roles.add(authority);
			}
			return roles;
		}

		return new ArrayList<GrantedAuthority>();
	}
}