/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.ldap;

import java.util.List;
import java.util.Set;

import gov.va.med.fw.model.ldap.LdapGroup;
import gov.va.med.fw.model.ldap.SearchCriteria;

/**
 * Service Interface for Ldap Group.
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author DNS
 */
public interface LdapGroupService {
	public void create(String name, Set members, List ouList);

	public void create(LdapGroup group);

//	public void update(LdapGroup group);

	public void delete(LdapGroup group);

	public LdapGroup findByDistinguishedName(String dn);

	public List find(SearchCriteria criteria);

	public LdapGroup findByCN(String groupCn);

	public List findAll();
}
