// Created May 24, 2005 10:51:25 AM

/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.jms;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;

import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.BuilderException;

/**
 * Simple wrapper when "building" implies simply getting the payload in a JMS
 * Message.
 * 
 * DNS
 */
public class WrappedObjectBuilder extends AbstractBuilder {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7410406623154234070L;

	public Object build(JMSMetaData meta) throws BuilderException {
		return getWrappedObject(meta.getJMSMessage());
	}

	public static Object getWrappedObject(Message msg) throws BuilderException {
		try {
			if (msg instanceof ObjectMessage)
				return ((ObjectMessage) msg).getObject();
			else if (msg instanceof TextMessage)
				return ((TextMessage) msg).getText();
			else if (msg instanceof MapMessage) {
				// rebuild the Map
				Map<String, Serializable> data = new HashMap<String, Serializable>();
				Enumeration mapNames = ((MapMessage) msg).getMapNames();
				String key = null;
				while (mapNames.hasMoreElements()) {
					key = (String) mapNames.nextElement();
					data.put(key, (Serializable) ((MapMessage) msg).getObject(key));
				}
				return data;
			} else
				throw new BuilderException(
						"The JMS Message is not capable of having a wrapped Object");
		} catch (JMSException e) {
			throw new BuilderException("Exception while getting wrapped Object", e);
		}
	}
}
