/********************************************************************
 * Copyright @ 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.event;

// Framework classes
import org.springframework.context.ApplicationEvent;

import gov.va.med.fw.service.AbstractComponent;

/**
 * A synchronous service event. This event is handled in an
 * ApplicationListenerService on the same thread as an event source. To handle
 * an event on a different thread, an AsynchServiceEvent should be used instead.
 * 
 * @author Vu Le
 * @version 1.0
 */
public class ServiceEvent extends ApplicationEvent {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1190197595016691581L;

	/**
	 * An event triggered by the specific source
	 * 
	 * @param A
	 *            source of an event
	 */
	public ServiceEvent(Object source) {
		super(source);
	}

	/**
	 * Returns a service class that trigger this event. A service class is a
	 * class that extends from an AbstractComponent class.
	 * 
	 * @return An abstract service class that triggers the event
	 */
	public AbstractComponent getService() {

		AbstractComponent service = null;

		if (getSource() instanceof AbstractComponent) {
			service = (AbstractComponent) getSource();
		}
		return service;
	}
}
