/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.scheduling;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.Trigger.CompletedExecutionInstruction;
import org.quartz.TriggerListener;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Alternative to Quartz LoggingTriggerHistoryPlugin (since that requires an
 * external quartz.properties file).
 * 
 * Created Jan 30, 2006 11:23:46 AM
 * 
 * DNS
 */
public class ScheduledProcessListener extends AbstractComponent implements TriggerListener { 
	
	private Logger logger = Logger.getLogger(ScheduledProcessListener.class);
	
	private String name;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.quartz.TriggerListener#triggerFired(org.quartz.Trigger,
	 * org.quartz.JobExecutionContext)
	 */
	public void triggerFired(Trigger trigger, JobExecutionContext context) {
		if (logger.isInfoEnabled()) {
			StringBuilder buf = new StringBuilder();
			buf.append("ScheduledProcessListener.triggerFired at ");
			buf.append(new Date()).append(": ").append(trigger.getKey().getGroup()).append(".").append(
					trigger.getKey().getName());
			buf.append(" with merged trigger/job data: ");
			// iterate and list each element
			Map data = context.getMergedJobDataMap().getWrappedMap();
			Iterator itr = data != null ? data.entrySet().iterator() : null;
			Map.Entry entry = null;
			while (itr != null && itr.hasNext()) {
				entry = (Map.Entry) itr.next();
				if (entry.getValue() instanceof Object[]) {
					Object[] array = (Object[]) entry.getValue();
					for (int i = 0; i < array.length; i++) {
						buf.append(entry.getKey()).append("[").append(i).append("]=").append(
								array[i]);
						if ((i + 1) < array.length)
							buf.append(",");
					}
				} else {
					buf.append(entry.getKey()).append("=").append(entry.getValue());
				}
				if (itr.hasNext())
					buf.append(", ");
			}
			logger.info(buf.toString());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.quartz.TriggerListener#vetoJobExecution(org.quartz.Trigger,
	 * org.quartz.JobExecutionContext)
	 */
	public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
		if (logger.isDebugEnabled())
			logger.debug("ScheduledProcessListener.vetoJobExecution at " + new Date() + ": "
					+ trigger.getKey().getGroup() + "." + trigger.getKey().getName());

		// do not veto!
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.quartz.TriggerListener#triggerMisfired(org.quartz.Trigger)
	 */
	public void triggerMisfired(Trigger trigger) {
		if (logger.isInfoEnabled())
			logger.info("ScheduledProcessListener.triggerMisfired at " + new Date() + ": "
					+ trigger.getKey().getGroup() + "." + trigger.getKey().getName());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.quartz.TriggerListener#triggerComplete(org.quartz.Trigger,
	 * org.quartz.JobExecutionContext, int)
	 */
	public void triggerComplete(Trigger trigger, JobExecutionContext context,
			int triggerInstructionCode) {
		if (logger.isInfoEnabled())
			logger.info("ScheduledProcessListener.triggerComplete at " + new Date() + ": "
					+ trigger.getKey().getGroup() + "." + trigger.getKey().getName());
	}

	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public void triggerComplete(Trigger trigger, JobExecutionContext context,
			CompletedExecutionInstruction triggerInstructionCode) {

		logger.error("$$$$ Need to implement.");
		
	}

}
