/**
 * Created on 4:50:55 PM Jan 3, 2005
 * Project: Framework
 * 
 * @author DNS
 */
package gov.va.med.fw.rule.impl;

// ILOG classes
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.fw.rule.RuleExceptionHandler;

/**
 * A generic rule exception handler that handles user exception triggered in an
 * evaluation or action part of a rule. This exception handler is set into a
 * IlrContext of a rule set only if the exception handler is set in a Rule
 * wrapper class through its rule interface.
 */
public class SimpleRuleExceptionHandler implements RuleExceptionHandler {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5121662021596048477L;
	/**
	 * An instance of a log component used for logging information
	 */
	protected Log logger = LogFactory.getLog(getClass());

	/**
	 * A default constructor
	 */
	public SimpleRuleExceptionHandler() {
		super();
	}

	/**
	 * @see gov.va.med.fw.rule.RuleExceptionHandler#handleConditionException(java.lang.Exception)
	 */
	public boolean handleConditionException(Exception e) {
		logException(e);
		return false;
	}

	/**
	 * @see gov.va.med.fw.rule.RuleExceptionHandler#handleActionException(java.lang.Exception)
	 */
	public void handleActionException(Exception e) {
		logException(e);
		if (e instanceof RuntimeException) {
			throw (RuntimeException) e;
		}
	}

	/**
	 * @see gov.va.med.fw.rule.RuleExceptionHandler#handleInternalException(java.lang.Exception)
	 */
	public void handleInternalException(Exception e) {
		logException(e);
		if (e instanceof RuntimeException) {
			throw (RuntimeException) e;
		}
	}

	/**
	 * Log an exception. If an error level is set, an exception and its member
	 * (method or field) from which an exception is triggered is logged
	 * 
	 * @param e
	 *            An exception to be logged
	 */
	protected void logException(Exception e) {
		if (logger.isDebugEnabled()) {
			logger.debug("A root cause exception: " + e.getCause().getClass().getName());
			logger.debug("Exception details: ", e);
		}
	}
}