/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report.data;

// Java classes
import java.io.Serializable;
import java.util.List;

import org.hibernate.ScrollableResults;

import gov.va.med.fw.report.ReportConfiguration;

// ESR classes

/**
 * Provides methods to obtain a report data in a collection of row data. For
 * efficiency, a report engine only builds a managable and configurable size of
 * collection at a time instead of pulling all data into its
 * 
 * Project: Framework</br> Created on: 4:22:21 PM </br>
 * 
 * @author DNS
 */
public interface ReportDataDAO extends Serializable {

	/**
	 * Allows concrete implementation class to perform any pre process before
	 * data is retrieved
	 * 
	 * @param config
	 *            A report configuration
	 * @throws ReportDataException
	 *             In case of errors accessing a collection
	 */
	public void preDataRetrieval(final ReportConfiguration config) throws ReportDataException;

	/**
	 * Returns the scrollable result set
	 * 
	 * @param config
	 * @return
	 * @throws ReportDataException
	 */
	public ScrollableResults getResults(final ReportConfiguration config)
			throws ReportDataException;

	/**
	 * Get report data in configurable set
	 * 
	 * @param firstRecord
	 *            A first record index
	 * @param maxRecord
	 *            A threadhold value of records
	 * @param config
	 *            A report configuration
	 * @return A collection returned from a postDataRetrieval method is called
	 * @throws ReportDataException
	 *             In case of errors accessing a collection
	 */
	public List getRecords(final ReportConfiguration config, final int firstRecord,
			final int maxRecord) throws ReportDataException;

	/**
	 * Allows concrete implementation class to perform any post process after
	 * data is retrieved
	 * 
	 * @param results
	 *            A collection of result items
	 * @param config
	 *            A report configuration
	 * @return A collection returned from a postDataRetrieval method is called
	 * @throws ReportDataException
	 *             In case of errors accessing a collection
	 */
	public List postDataRetrieval(final List results, final ReportConfiguration config)
			throws ReportDataException;
}