/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.fw.report;

import gov.va.med.fw.service.AbstractComponent;

/**
 * A ReportNameResolver that simply returns the name of the report as the report
 * name.
 * <p>
 * Project: Framework<br>
 * Created on: 4:10:59 PM
 * 
 * @author DNS
 */
public class SimpleReportNameResolver extends AbstractComponent implements ReportNameResolver {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8501385417540975648L;

	/**
	 * A default constructor
	 */
	public SimpleReportNameResolver() {
		super();
	}

	/**
	 * @see gov.va.med.fw.report.ReportNameResolver#getReportName(gov.va.med.fw.report.ReportConfiguration)
	 */
	public String getReportName(ReportConfiguration config) {
		String name = config != null ? config.getReportName() : null;
		return name;
	}
}
