/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.persistent.ldap;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

import org.springframework.ldap.core.AttributesMapper;

import gov.va.med.fw.model.ldap.LdapConstants;
import gov.va.med.fw.model.ldap.LdapPerson;

/**
 * Maps attributes from DirContextOperations to properties of LdapPerson.
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author DNS
 */
public class PersonContextMapper implements AttributesMapper<LdapPerson>, LdapConstants {
	private String groupOU;

	public void setGroupOU(String groupOU) {
		this.groupOU = groupOU;
	}

	/*public Object mapFromContext(Object ctx) {
		DirContextOperations dirContext = (DirContextOperations) ctx;
		LdapPerson person = new LdapPerson();
		person.setDn(dirContext.getStringAttribute(DISTINGUISHED_NAME));
		person.setShortDnString(dirContext.getDn().toString());
		person.setFullName(dirContext.getStringAttribute(CN));
		person.setDisplayName(dirContext.getStringAttribute(DISPLAY_NAME));
		person.setLastName(dirContext.getStringAttribute(SN));
		person.setFirstName(dirContext.getStringAttribute(GIVEN_NAME));
		person.setMiddleName(dirContext.getStringAttribute(MIDDLE_NAME));
		person.setSamAccountName(dirContext.getStringAttribute(SAM_ACCOUNT_NAME));
		person.setUserPrincipalName(dirContext.getStringAttribute(USER_PRINCIPAL));
		person.setBadPasswordCount(dirContext.getStringAttribute(BAD_PWD_COUNT));
		person.setTitle(dirContext.getStringAttribute(TITLE));
		person.setDescription(dirContext.getStringAttribute(DESCRIPTION));
		person.setDepartment(dirContext.getStringAttribute(DEPARTMENT));
		person.setOffice(dirContext.getStringAttribute(OFFICE));
		person.setTelephoneNumber(dirContext.getStringAttribute(TELEPHONE_NUMBER));
		person.setEmail(dirContext.getStringAttribute(EMAIL));

		String[] groupsArray = dirContext.getStringAttributes(MEMBER_OF);
		if (groupsArray != null) {
			List<String> groups = Arrays.asList(groupsArray);
			List<String> cissGroups = new ArrayList<String>();

			for (Iterator i = groups.iterator(); i.hasNext();) {
				String userDn = (String) i.next();

				if (userDn.contains(OU_CISS) && userDn.contains("=" + groupOU))
					// Add only the CN portion of the distinguished name
					cissGroups.add(userDn.substring(3, userDn.indexOf(COMMA)));

			}
			person.setGroups(new TreeSet<String>(groups));
			person.setCissGroups(new TreeSet<String>(cissGroups));
		}
		return person;
	}*/

	@Override
	public LdapPerson mapFromAttributes(Attributes attributes) throws NamingException {
		LdapPerson person = new LdapPerson();
		person.setDn(attributes.get(DISTINGUISHED_NAME).get().toString());
		person.setFullName(attributes.get(CN).get().toString());
		person.setDisplayName(attributes.get(DISPLAY_NAME).get().toString());
		person.setLastName(attributes.get(SN).get().toString());
		person.setFirstName(attributes.get(GIVEN_NAME).get().toString());
		// Middle name is optional from LDAP
		if(attributes.get(MIDDLE_NAME) != null) {
			person.setMiddleName(attributes.get(MIDDLE_NAME).get().toString());
		}
		else {
			person.setMiddleName("");
		}
		person.setSamAccountName(attributes.get(SAM_ACCOUNT_NAME).get().toString());
		person.setUserPrincipalName(attributes.get(USER_PRINCIPAL).get().toString());
		if(attributes.get(TITLE) != null) {
			person.setTitle(attributes.get(TITLE).get().toString());
		}
		else {
			person.setTitle("");
		}
		if(attributes.get(DESCRIPTION) != null) {
			person.setDescription(attributes.get(DESCRIPTION).get().toString());
		}
		else {
			person.setDescription("");
		}
		if(attributes.get(DEPARTMENT) != null) {
			person.setDepartment(attributes.get(DEPARTMENT).get().toString());
		}
		else {
			person.setDepartment("");
		}
		if(attributes.get(OFFICE) != null) {
			person.setOffice(attributes.get(OFFICE).get().toString());
		}
		else {
			person.setOffice("");
		}
		if(attributes.get(TELEPHONE_NUMBER) != null) {
			person.setTelephoneNumber(attributes.get(TELEPHONE_NUMBER).get().toString());
		}
		else {
			person.setTelephoneNumber("");
		}
		person.setEmail(attributes.get(EMAIL).get().toString());
		
		NamingEnumeration<?> namingGroups = attributes.get(MEMBER_OF).getAll();
		if (namingGroups != null) {
			List<String> cissGroups = new ArrayList<String>();
			Set<String> groups = new TreeSet<String>();
			while(namingGroups.hasMore()) {
				String userDn = (String) namingGroups.next();
				groups.add(userDn);
				if (userDn.contains(OU_CISS) && userDn.contains("=" + groupOU))
					// Add only the CN portion of the distinguished name
					cissGroups.add(userDn.substring(3, userDn.indexOf(COMMA)));

			}
			person.setGroups(new TreeSet<String>(groups));
			person.setCissGroups(new TreeSet<String>(cissGroups));
		}
		return person;
	}
}
