/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.persistent.ldap;

import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextOperations;

import gov.va.med.fw.model.ldap.LdapConstants;
import gov.va.med.fw.model.ldap.LdapGroup;

/**
 * Maps attributes from DirContextOperations to properties of LdapGroup.
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author DNS
 */
public class GroupContextMapper implements ContextMapper, LdapConstants {

	public Object mapFromContext(Object ctx) {
		DirContextOperations dirContext = (DirContextOperations) ctx;
		LdapGroup group = new LdapGroup();
		group.setCnName(dirContext.getStringAttribute(CN));
		group.setDistinguishedName(dirContext.getStringAttribute(DISTINGUISHED_NAME));
		group.setSamAccountName(dirContext.getStringAttribute(SAM_ACCOUNT_NAME));

		String[] membersArray = dirContext.getStringAttributes(MEMBER);
		if (membersArray != null) {
			List list = Arrays.asList(membersArray);
			group.setMembers(new TreeSet(list));
		}

		return group;
	}
}
