/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.model.lookup;

import java.util.Map;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.enums.Enum;
import org.springframework.core.Constants;

/**
 * Lookup implementation for enumerated values that are not database driven.
 * 
 * Created Aug 3, 2006 4:19:58 PM
 * 
 * DNS
 */
public abstract class AbstractSimpleLookup extends Enum implements Lookup {
	private static final long serialVersionUID = -1063943405242112824L;

	public AbstractSimpleLookup(String code) {
		super(code);
		SimpleLookupUtils.addLookupClass(getClass());
	}

	public String getCode() {
		return getName();
	}

	public String getDescription() {
		return SimpleLookupUtils.getConstantName(getClass(), getCode());
	}

	public final String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append(ClassUtils.getShortClassName(getClass())).append(" [");
		buf.append(getCode()).append(", ");
		buf.append(getDescription()).append("]");
		return buf.toString();
	}
}

class EnumConstants extends Constants {
	EnumConstants(Class<?> clazz) {
		super(clazz);
	}

	@SuppressWarnings("unchecked")
	String getConstantName(String code) {
		Map<String, Object> constantToLookup = getFieldCache();
		//Map<String, Lookup> constantToLookup = getFieldCache();
		for (Map.Entry<String, Object> entry : constantToLookup.entrySet()) {
			if (code.equals(((Lookup)entry.getValue()).getCode()))
				return entry.getKey();
		}
		return null;
	}
}
