package gov.va.med.fw.model.lookup;

import org.apache.commons.lang.builder.CompareToBuilder;

/**
 * A lookup that has the qualities of 1) a name, 2) an active flag and 3) a
 * sortOrder field. This should be mapped to a database table with all three
 * fields required.
 * 
 * @author DNS
 * 
 */
public class AbstractNamedActiveSortedLookup extends AbstractNamedActiveLookup implements
		Comparable<AbstractNamedActiveSortedLookup> {

	private static final long serialVersionUID = -5425138464281507257L;

	private int sortOrder = -1;

	/**
	 * Returns a value that describes the relative position of the object when
	 * in a sorted collection.
	 * 
	 * @return A value that describes the relative position of the object when
	 *         in a sorted collection.
	 */
	public int getSortOrder() {
		return sortOrder;
	}

	/**
	 * Sets a value that describes the relative position of the object when in a
	 * sorted collection.
	 * 
	 * @param sortOrder
	 *            A value that describes the relative position of the object
	 *            when in a sorted collection.
	 */
	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}

	/**
	 * @param o
	 *            The AbstractNamedActiveSortedLookup to which we are comparing
	 *            ourself
	 * @return If the specified object is null, returns -1. If the specified
	 *         object is equal() to this object, return 0. Otherwise, returns 1
	 *         if this object's sort order is greater than the specified
	 *         AbstractNamedActiveSortedLookup's sort order, and -1 otherwise.
	 */
	public int compareTo(AbstractNamedActiveSortedLookup o) {
		if (o == null)
			return -1;
		if (equals(o))
			return 0;
		return new CompareToBuilder().append(getSortOrder(), o.getSortOrder()).toComparison() > 0 ? 1
				: -1;
	}
}
