package gov.va.med.fw.model.lookup;

//Java Classes

//Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

//Framework Classes

/**
 * An abstract class that is used as a base class for all lookup entities with a
 * unique name
 * 
 * Project: Framework</br> Created on: 12:51:08 PM </br>
 * 
 * @author DNS
 */
public abstract class AbstractNamedActiveLookup extends AbstractNamedLookup {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1861808532240596905L;
	/**
	 * Whether the object has been marked active.
	 * 
	 */
	private boolean active = false;

	/**
	 * Default constructor.
	 */
	public AbstractNamedActiveLookup() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.esr.common.model.lookup.CodedDescriptionLookup#buildToString
	 * (org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("active", this.active);
	}

	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}
}