/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.model.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.core.style.ToStringCreator;

/**
 * Class representing search criteria used to search for an Ldap Group or Person
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author DNS
 */
public class SearchCriteria implements Serializable, LdapConstants {

	private static final long serialVersionUID = -4263208255805049113L;
	
	public static final String STAFF_SEARCH = "STAFF_SEARCH";
	public static final String ADMIN_SEARCH = "ADMIN_SEARCH";
	
	private String sAMAccountName = "";
	private String groupName = "";
	private String lastName = "";
	private String firstName = "";
	private String middleName = "";
	private String name = "";

	private List<String> visns = new ArrayList<String>();
	private List<String> stations = new ArrayList<String>();
	private List<String> roles = new ArrayList<String>();
	private List<String> vendors = new ArrayList<String>();
	
	private String searchType = STAFF_SEARCH;

	public String getSAMAccountName() {
		return sAMAccountName;
	}

	public void setSAMAccountName(String sAMAccountName) {
		this.sAMAccountName = sAMAccountName;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setUserID(String userID) {
		this.sAMAccountName = userID;
	}

	public String getUserID() {
		return this.sAMAccountName;
	}

	public List<String> getVisns() {
		return visns;
	}

	public void setVisns(List<String> visns) {
		this.visns = visns;
	}

	public List<String> getStations() {
		return stations;
	}

	public void setStations(List<String> stations) {
		this.stations = stations;
	}

	public List<String> getRoles() {
		return roles;
	}

	public void setRoles(List<String> roles) {
		this.roles = roles;
	}

	public List<String> getVendors() {
		return vendors;
	}

	public void setVendors(List<String> vendors) {
		this.vendors = vendors;
	}

	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}

	public boolean equals(Object obj) {
		if (obj == null || getClass() != obj.getClass())
			return false;
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	public String getSearchType() {
		return searchType;
	}

	public void setSearchType(String searchType) {
		this.searchType = searchType;
	}

	public String toString() {
		return new ToStringCreator(this).append(SAM_ACCOUNT_NAME, sAMAccountName).toString();
	}
}