/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.model.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * Class representing an Ldap Group
 * 
 * CISS ciss_framework Jun 23, 2008
 * 
 * @author DNS
 */
public class LdapGroup implements Serializable {
	private static final long serialVersionUID = -360943117484570379L;
	private String cnName;
	private String distinguishedName;
	private Set members = new TreeSet();
	private List ouList = new ArrayList();
	private String groupType;
	private String samAccountName;

	/**
	 * @return Returns a Set of Distinguished Names for Members belonging to the
	 *         Ldap Group.
	 */
	public Set getMembers() {
		return members;
	}

	/**
	 * @param members
	 *            The Set of Group Members' Distinguished Names to set.
	 */
	public void setMembers(Set members) {
		this.members = members;
	}

	/**
	 * @return Returns the CN (Name) of the Ldap Group.
	 */
	public String getCnName() {
		return cnName;
	}

	/**
	 * @param cnName
	 *            The CN (Name) to set.
	 */
	public void setCnName(String cnName) {
		this.cnName = cnName;
	}

	/**
	 * @return Returns the Distinguished Name of the Ldap Group.
	 */
	public String getDistinguishedName() {
		return distinguishedName;
	}

	/**
	 * @param distinguishedName
	 *            The Distinguished Name to set.
	 */
	public void setDistinguishedName(String distinguishedName) {
		this.distinguishedName = distinguishedName;
	}

	/**
	 * @return Returns the list of OUs for the Ldap Group, which should include
	 *         CISS, Partners, and Groups.
	 */
	public List getOuList() {
		return ouList;
	}

	/**
	 * @param dn
	 *            The list of OUs to set.
	 */
	public void setOuList(List ouList) {
		this.ouList = ouList;
	}

	/**
	 * @return Returns the sAMAccountName of the Ldap Group.
	 */
	public String getSamAccountName() {
		return samAccountName;
	}

	/**
	 * @param samAccountName
	 *            The sAMAccountName to set.
	 */
	public void setSamAccountName(String samAccountName) {
		this.samAccountName = samAccountName;
	}

	public boolean equals(Object obj) {
		if (obj == null || getClass() != obj.getClass()) {
			return false;
		}
		return EqualsBuilder.reflectionEquals(this, obj);
	}

	public int hashCode() {
		return HashCodeBuilder.reflectionHashCode(this);
	}
}
