package gov.va.med.fw.model.batchprocess;

import java.util.Date;
import java.util.TimeZone;

import gov.va.med.fw.util.date.TimeZoneUtils;

public class BatchJobExecution extends AbstractJob<BatchJobExecution> {

	private static final long serialVersionUID = -8143261669225991064L;

	private Date startDate;
	private String formattedStartDate="";
	private Date endDate;
	private String formattedEndDate="";
	private String status;
	private String exitStatus;
	private String exitMessage;
	private String continuable;
	private Date createDate;
	private String runBy;
	private String statistics;

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getExitMessage() {
		return exitMessage;
	}

	public void setExitMessage(String existMessage) {
		this.exitMessage = existMessage;
	}

	public String getExitStatus() {
		return exitStatus;
	}

	public void setExitStatus(String exitStatus) {
		this.exitStatus = exitStatus;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatistics() {
		return statistics;
	}

	public void setStatistics(String statistics) {
		this.statistics = statistics;
	}

	public String getContinuable() {
		return continuable;
	}

	public void setContinuable(String continuable) {
		this.continuable = continuable;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public String getRunBy() {
		return runBy;
	}

	public void setRunBy(String runBy) {
		this.runBy = runBy;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public String getFormattedStartDate() {
		if(startDate!=null)
		{
			return TimeZoneUtils.convertDateToTimeZone(startDate, TimeZone.getDefault());
		}
		else return formattedStartDate;
	}


	public void setFormattedStartDate(String formattedStartDate) {
		this.formattedStartDate = formattedStartDate;
	}

	public String getFormattedEndDate() {
		if(endDate!=null)
		{
			return TimeZoneUtils.convertDateToTimeZone(endDate, TimeZone.getDefault());
		}
		else return formattedEndDate;
	}

	public void setFormattedEndDate(String formattedEndDate) {
		this.formattedEndDate = formattedEndDate;
	}
	
}
