/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.model;

import java.io.Serializable;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Factory for creating appropriate EntityKey implementations.
 * 
 * Created Jul 31, 2005 9:50:27 PM
 * 
 * DNS
 */
public class EntityKeyFactory extends AbstractComponent {
	public static <T> EntityKey<T> createEntityKey(Serializable identifier, Class<T> targetClass) {
		return new BaseEntityKey<T>(identifier, targetClass);
	}

	public static <T> EntityKey<T> createEntityKey(Serializable identifier, Integer version,
			Class<T> targetClass) {
		return new BaseEntityKey<T>(identifier, version, targetClass);
	}
}
