/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.io;

import org.apache.commons.collections.OrderedMap;

import com.infomata.data.DataRow;

/**
 * Allows for implementors to deal directly with file data for manual
 * manipulation. Useful for large files where the volume of metadata is too
 * costly of a memory footprint.
 * 
 * Created Mar 16, 2006 1:09:34 PM
 * 
 * DNS
 */
public interface RawFileDataContainer {
	/**
	 * Used to manually populate objects from file data while parsing
	 * 
	 * @param rawFileData
	 * @param parsedRow
	 * @param classMapping
	 *            Useful in case of leveraging configuration-based transforms
	 *            (if any)
	 * @throws Exception
	 */
	public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping)
			throws Exception;

	/**
	 * Used to manually populate objects for file data while writing
	 * 
	 * @return OrderedMap allows for strict ordering AND name-based matching of
	 *         configuration-based transforms (if any)
	 * @throws Exception
	 */
	public OrderedMap getRawFileData() throws Exception;

	/**
	 * Used to bootstrap auto registration of classes for conversion. This list
	 * does not need to include the implementing class, nor any classes that are
	 * reachable by its Class (not instance) graph.
	 * 
	 * @return
	 */
	public Class[] getClassesForAutoRegisterConverters();
}
