/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.InvalidConfigurationException;

/**
 * Maps a target Class to FileFieldMetaData information.
 * 
 * Created Feb 21, 2006 3:09:06 PM
 * 
 * DNS
 */
public class ClassMapping extends AbstractComponent {
	private Class targetClass;

	private List fieldsMetaData;
	private Map fieldsMetaDataMap;

	/**
	 * If true, use index as name of the field
	 */
	private boolean explicitFieldsMetaDataOrdering = false;

	private boolean sectionHeaderOnSeparateLine = true;

	/**
	 * @return Returns the fieldsMetaData.
	 */
	public List getFieldsMetaData() {
		return fieldsMetaData;
	}

	/**
	 * @param fieldsMetaData
	 *            The fieldsMetaData to set.
	 */
	public void setFieldsMetaData(List fieldsMetaData) {
		this.fieldsMetaData = fieldsMetaData;
	}

	public boolean hasFieldsMetaData() {
		return fieldsMetaData != null && !fieldsMetaData.isEmpty();
	}

	/**
	 * @return Returns the explicitFieldsMetaDataOrdering.
	 */
	public boolean isExplicitFieldsMetaDataOrdering() {
		return explicitFieldsMetaDataOrdering;
	}

	/**
	 * @param explicitFieldsMetaDataOrdering
	 *            The explicitFieldsMetaDataOrdering to set.
	 */
	public void setExplicitFieldsMetaDataOrdering(boolean explicitFieldsMetaDataOrdering) {
		this.explicitFieldsMetaDataOrdering = explicitFieldsMetaDataOrdering;
	}

	/**
	 * @return Returns the targetClass.
	 */
	public Class getTargetClass() {
		return targetClass;
	}

	/**
	 * @param targetClass
	 *            The targetClass to set.
	 */
	public void setTargetClass(Class targetClass) {
		this.targetClass = targetClass;
	}

	public FileFieldMetaData getFieldMetaData(String name) {
		return fieldsMetaDataMap != null ? (FileFieldMetaData) fieldsMetaDataMap.get(name) : null;
	}

	public void afterPropertiesSet() {
		Validate.notNull(targetClass, "targetClass can not be null");
		if ((fieldsMetaData == null || fieldsMetaData.isEmpty())
				&& !RawFileDataContainer.class.isAssignableFrom(targetClass))
			throw new InvalidConfigurationException(
					"Either fieldsMetaData must be provided or the targetClass must implement RawFileDataContainer");
		if (fieldsMetaData != null) {
			fieldsMetaDataMap = new HashMap();
			Iterator itr = fieldsMetaData.iterator();
			FileFieldMetaData meta = null;
			while (itr.hasNext()) {
				meta = (FileFieldMetaData) itr.next();
				fieldsMetaDataMap.put(meta.getName(), meta);
			}
		}
	}

	/**
	 * @return Returns the sectionHeaderOnSeparateLine.
	 */
	public boolean isSectionHeaderOnSeparateLine() {
		return sectionHeaderOnSeparateLine;
	}

	/**
	 * @param sectionHeaderOnSeparateLine
	 *            The sectionHeaderOnSeparateLine to set.
	 */
	public void setSectionHeaderOnSeparateLine(boolean sectionHeaderOnSeparateLine) {
		this.sectionHeaderOnSeparateLine = sectionHeaderOnSeparateLine;
	}
}
