/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZPD segment containing information about batch trailer
 * 
 * @author Alex YoonRR
 * @version 1.0
 */

public class ZPD extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1114467228628822918L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZPD() {
		super();
		setName(SegmentConstants.ZPD);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZPD(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZPD(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZPD(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZPD(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * REMARKS (.091)
	 * 
	 * @param input
	 *            A value of Remarks
	 */
	public void setRemarks(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * REMARKS (.091)
	 * 
	 * @return String A value of Remarks
	 */
	public String getRemarks() {
		return getElement(1);
	}

	/**
	 * 
	 * PLACE OF BIRTH CITY (.092)
	 * 
	 * @param input
	 *            A value of BirthCity
	 */
	public void setBirthCity(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * PLACE OF BIRTH CITY (.092)
	 * 
	 * @return String A value of BirthCity
	 */
	public String getBirthCity() {
		return getElement(2);
	}

	/**
	 * 
	 * PLACE OF BIRTH STATE (.093) abbreviation only
	 * 
	 * @param input
	 *            A value of BirthState
	 */
	public void setBirthState(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * PLACE OF BIRTH STATE (.093) abbreviation only
	 * 
	 * @return String A value of BirthState
	 */
	public String getBirthState() {
		return getElement(3);
	}

	/**
	 * 
	 * CURRENT MEANS TEST STATUS (.14)
	 * 
	 * @param input
	 *            A value of CurrentMeansTestStatus
	 */
	public void setCurrentMeansTestStatus(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * CURRENT MEANS TEST STATUS (.14)
	 * 
	 * @return String A value of CurrentMeansTestStatus
	 */
	public String getCurrentMeansTestStatus() {
		return getElement(4);
	}

	/**
	 * 
	 * FATHER'S NAME (.2401)
	 * 
	 * @param input
	 *            A value of FatherName
	 */
	public void setFatherName(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * FATHER'S NAME (.2401)
	 * 
	 * @return String A value of FatherName
	 */
	public String getFatherName() {
		return getElement(5);
	}

	/**
	 * 
	 * MOTHER'S NAME (.2402)
	 * 
	 * @param input
	 *            A value of MotherName
	 */
	public void setMotherName(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * MOTHER'S NAME (.2402)
	 * 
	 * @return String A value of MotherName
	 */
	public String getMotherName() {
		return getElement(6);
	}

	/**
	 * 
	 * RATED INCOMPETENT (.293)
	 * 
	 * @param input
	 *            A value of RatedIncompetent
	 */
	public void setRatedIncompetent(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * RATED INCOMPETENT (.293)
	 * 
	 * @return String A value of RatedIncompetent
	 */
	public String getRatedIncompetent() {
		return getElement(7);
	}

	/**
	 * 
	 * DATE OF DEATH (.351) (Imprecise)
	 * 
	 * @param input
	 *            A value of DeathDate
	 */
	public void setDeathDate(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * DATE OF DEATH (.351) (Imprecise)
	 * 
	 * @return String A value of DeathDate
	 */
	public String getDeathDate() {
		return getElement(8);
	}

	/**
	 * 
	 * COLLATERAL SPONSOR (.3601)
	 * 
	 * @param input
	 *            A value of CollateralSponsor
	 */
	public void setCollateralSponsor(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * COLLATERAL SPONSOR (.3601)
	 * 
	 * @return String A value of CollateralSponsor
	 */
	public String getCollateralSponsor() {
		return getElement(9);
	}

	/**
	 * 
	 * ACTIVE HEALTH INSURANCE? (computed)
	 * 
	 * @param input
	 *            A value of ActiveHealthInsurance
	 */
	public void setActiveHealthInsurance(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * ACTIVE HEALTH INSURANCE? (computed)
	 * 
	 * @return String A value of ActiveHealthInsurance
	 */
	public String getActiveHealthInsurance() {
		return getElement(10);
	}

	/**
	 * 
	 * ELIGIBLE FOR MEDICAID? (.381)
	 * 
	 * @param input
	 *            A value of EligibleForMedicaid
	 */
	public void setEligibleForMedicaid(String input) {
		setElement(input, 11);
	}

	/**
	 * 
	 * ELIGIBLE FOR MEDICAID? (.381)
	 * 
	 * @return String A value of EligibleForMedicaid
	 */
	public String getEligibleForMedicaid() {
		return getElement(11);
	}

	/**
	 * 
	 * DATE MEDICAID LAST ASKED (.382) (Precise)
	 * 
	 * @param input
	 *            A value of MedicaidLastAskedDate
	 */
	public void setMedicaidLastAskedDate(String input) {
		setElement(input, 12);
	}

	/**
	 * 
	 * DATE MEDICAID LAST ASKED (.382) (Precise)
	 * 
	 * @return String A value of MedicaidLastAskedDate
	 */
	public String getMedicaidLastAskedDate() {
		return getElement(12);
	}

	/**
	 * 
	 * RACE (.06)
	 * 
	 * @param input
	 *            A value of Race
	 */
	public void setRace(String input) {
		setElement(input, 13);
	}

	/**
	 * 
	 * RACE (.06)
	 * 
	 * @return String A value of Race
	 */
	public String getRace() {
		return getElement(13);
	}

	/**
	 * 
	 * RELIGION (.08)
	 * 
	 * @param input
	 *            A value of Religion
	 */
	public void setReligion(String input) {
		setElement(input, 14);
	}

	/**
	 * 
	 * RELIGION (.08)
	 * 
	 * @return String A value of Religion
	 */
	public String getReligion() {
		return getElement(14);
	}

	/**
	 * 
	 * HOMELESS INDICATOR (computed)
	 * 
	 * @param input
	 *            A value of HomelessIndicator
	 */
	public void setHomelessIndicator(String input) {
		setElement(input, 15);
	}

	/**
	 * 
	 * HOMELESS INDICATOR (computed)
	 * 
	 * @return String A value of HomelessIndicator
	 */
	public String getHomelessIndicator() {
		return getElement(15);
	}

	/**
	 * 
	 * POW STATUS INDICATED? (.525) Y=YES, N=NO, U=UNKNOWN
	 * 
	 * @param input
	 *            A value of PowStatusIndicated
	 */
	public void setPowStatusIndicated(String input) {
		setElement(input, 16);
	}

	/**
	 * 
	 * POW STATUS INDICATED? (.525) Y=YES, N=NO, U=UNKNOWN
	 * 
	 * @return String A value of PowStatusIndicated
	 */
	public String getPowStatusIndicated() {
		return getElement(16);
	}

	/**
	 * 
	 * TYPE OF INSURANCE (computed)
	 * 
	 * @param input
	 *            A value of InsuranceType
	 */
	public void setInsuranceType(String input) {
		setElement(input, 17);
	}

	/**
	 * 
	 * TYPE OF INSURANCE (computed)
	 * 
	 * @return String A value of InsuranceType
	 */
	public String getInsuranceType() {
		return getElement(17);
	}

	/**
	 * 
	 * MEDICATION COPAY EXEMPTION STATUS (computed) (#354) (.04)
	 * 
	 * @param input
	 *            A value of MedicationCopayExemptionStatus
	 */
	public void setMedicationCopayExemptionStatus(String input) {
		setElement(input, 18);
	}

	/**
	 * 
	 * MEDICATION COPAY EXEMPTION STATUS (computed) (#354) (.04)
	 * 
	 * @return String A value of MedicationCopayExemptionStatus
	 */
	public String getMedicationCopayExemptionStatus() {
		return getElement(18);
	}

	/**
	 * 
	 * POW CONFINEMENT LOCATION (.526)
	 * 
	 * @param input
	 *            A value of PowConfinementLocation
	 */
	public void setPowConfinementLocation(String input) {
		setElement(input, 19);
	}

	/**
	 * 
	 * POW CONFINEMENT LOCATION (.526)
	 * 
	 * @return String A value of PowConfinementLocation
	 */
	public String getPowConfinementLocation() {
		return getElement(19);
	}

	/**
	 * 
	 * PRIMARY CARE TEAM (File# 404.51)
	 * 
	 * @param input
	 *            A value of PrimaryCareTeam
	 */
	public void setPrimaryCareTeam(String input) {
		setElement(input, 20);
	}

	/**
	 * 
	 * PRIMARY CARE TEAM (File# 404.51)
	 * 
	 * @return String A value of PrimaryCareTeam
	 */
	public String getPrimaryCareTeam() {
		return getElement(20);
	}

	/**
	 * 
	 * GI INSURANCE POLICY? (.36265)
	 * 
	 * @param input
	 *            A value of GiInsurancePolicy
	 */
	public void setGiInsurancePolicy(String input) {
		setElement(input, 21);
	}

	/**
	 * 
	 * GI INSURANCE POLICY? (.36265)
	 * 
	 * @return String A value of GiInsurancePolicy
	 */
	public String getGiInsurancePolicy() {
		return getElement(21);
	}

	/**
	 * 
	 * AMOUNT OF GI INSURANCE (.3626)
	 * 
	 * @param input
	 *            A value of GiInsuranceAmount
	 */
	public void setGiInsuranceAmount(String input) {
		setElement(input, 22);
	}

	/**
	 * 
	 * AMOUNT OF GI INSURANCE (.3626)
	 * 
	 * @return String A value of GiInsuranceAmount
	 */
	public String getGiInsuranceAmount() {
		return getElement(22);
	}

	/**
	 * 
	 * MOST RECENT DATE OF CARE (1010.151) (Precise)
	 * 
	 * @param input
	 *            A value of MostRecentCareDate
	 */
	public void setMostRecentCareDate(String input) {
		setElement(input, 23);
	}

	/**
	 * 
	 * MOST RECENT DATE OF CARE (1010.151) (Precise)
	 * 
	 * @return String A value of MostRecentCareDate
	 */
	public String getMostRecentCareDate() {
		return getElement(23);
	}

	/**
	 * 
	 * MOST RECENT LOCATION OF CARE (1010.152)
	 * 
	 * @param input
	 *            A value of MostRecentCareLocation
	 */
	public void setMostRecentCareLocation(String input) {
		setElement(input, 24);
	}

	/**
	 * 
	 * MOST RECENT LOCATION OF CARE (1010.152)
	 * 
	 * @return String A value of MostRecentCareLocation
	 */
	public String getMostRecentCareLocation() {
		return getElement(24);
	}

	/**
	 * 
	 * 2ND MOST RECENT DATE OF CARE (1010.153)
	 * 
	 * @param input
	 *            A value of SecondMostRecentCareDate
	 */
	public void setSecondMostRecentCareDate(String input) {
		setElement(input, 25);
	}

	/**
	 * 
	 * 2ND MOST RECENT DATE OF CARE (1010.153)
	 * 
	 * @return String A value of SecondMostRecentCareDate
	 */
	public String getSecondMostRecentCareDate() {
		return getElement(25);
	}

	/**
	 * 
	 * 2ND MOST RECENT LOCATION OF CARE (1010.154)
	 * 
	 * @param input
	 *            A value of SecondMostRecentCareLocation
	 */
	public void setSecondMostRecentCareLocation(String input) {
		setElement(input, 26);
	}

	/**
	 * 
	 * 2ND MOST RECENT LOCATION OF CARE (1010.154)
	 * 
	 * @return String A value of SecondMostRecentCareLocation
	 */
	public String getSecondMostRecentCareLocation() {
		return getElement(26);
	}

	/**
	 * 
	 * DATE RULED INCOMPETENT (CIVIL) (.292) (Imprecise)
	 * 
	 * @param input
	 *            A value of CivilIncompetentRuledDate
	 */
	public void setCivilIncompetentRuledDate(String input) {
		setElement(input, 27);
	}

	/**
	 * 
	 * DATE RULED INCOMPETENT (CIVIL) (.292) (Imprecise)
	 * 
	 * @return String A value of CivilIncompetentRuledDate
	 */
	public String getCivilIncompetentRuledDate() {
		return getElement(27);
	}

	/**
	 * 
	 * DATE RULED INCOMPETENT (VA) (.291) (Imprecise)
	 * 
	 * @param input
	 *            A value of VaIncompetentRuledDate
	 */
	public void setVaIncompetentRuledDate(String input) {
		setElement(input, 28);
	}

	/**
	 * 
	 * DATE RULED INCOMPETENT (VA) (.291) (Imprecise)
	 * 
	 * @return String A value of VaIncompetentRuledDate
	 */
	public String getVaIncompetentRuledDate() {
		return getElement(28);
	}

	/**
	 * 
	 * SPINAL CORD INJURY (57.4) Values: 1:PARAPLEGIA-TRAUMATIC
	 * 2:QUADRIPLEGIA-TRAUMATIC 3:PARAPLEGIA-NONTRAUMATIC
	 * 4:QUADRIPLEGIA-NONTRAUMATIC X:NOT APPLICABLE
	 * 
	 * @param input
	 *            A value of SpinalCordInjury
	 */
	public void setSpinalCordInjury(String input) {
		setElement(input, 29);
	}

	/**
	 * 
	 * SPINAL CORD INJURY (57.4) Values: 1:PARAPLEGIA-TRAUMATIC
	 * 2:QUADRIPLEGIA-TRAUMATIC 3:PARAPLEGIA-NONTRAUMATIC
	 * 4:QUADRIPLEGIA-NONTRAUMATIC X:NOT APPLICABLE
	 * 
	 * @return String A value of SpinalCordInjury
	 */
	public String getSpinalCordInjury() {
		return getElement(29);
	}

	/**
	 * 
	 * SOURCE OF NOTIFICATION (.353)
	 * 
	 * @param input
	 *            A value of NotificationSource
	 */
	public void setNotificationSource(String input) {
		setElement(input, 30);
	}

	/**
	 * 
	 * SOURCE OF NOTIFICATION (.353)
	 * 
	 * @return String A value of NotificationSource
	 */
	public String getNotificationSource() {
		return getElement(30);
	}

	/**
	 * 
	 * DATE/TIME LAST MODIFIED (.354) (Precise)
	 * 
	 * @param input
	 *            A value of LastModifiedDate
	 */
	public void setLastModifiedDate(String input) {
		setElement(input, 31);
	}

	/**
	 * 
	 * DATE/TIME LAST MODIFIED (.354) (Precise)
	 * 
	 * @return String A value of LastModifiedDate
	 */
	public String getLastModifiedDate() {
		return getElement(31);
	}

	/**
	 * 
	 * FILIPINO VETERAN DOCUMENT PROOF
	 * 
	 * @param input
	 *            A value of FilipinoVeteranProof
	 */
	public void setFilipinoVeteranProof(String input) {
		setElement(input, 32);
	}

	/**
	 * 
	 * FILIPINO VETERAN DOCUMENT PROOF
	 * 
	 * @return String A value of FilipinoVeteranProof
	 */
	public String getFilipinoVeteranProof() {
		return getElement(32);
	}

	/**
	 * Pseudo SSN Reason - Veteran
	 * 
	 */
	public void setPseudoSSNReason(String input) {
		setElement(input, 33);
	}

	/**
	 * Pseudo SSN Reason - Veteran
	 * 
	 * @return String value of PseudoSSNReason
	 */
	public String getPseudoSSNReason() {
		return getElement(33);
	}

	/**
	 * @param input
	 *            SignatureIndicator
	 */
	public void setAlliedCountryOrFederalAgency(String input) {
		setElement(input, 34);
	}

	/**
	 * Signature Indicator
	 * 
	 * @return value for SignatureIndicator
	 */
	public String getAlliedCountryOrFederalAgency() {
		return getElement(34);
	}

	/* Note that ESR does not use sequences 36-39 from ICD */

	/**
	 * @param input
	 *            EmergencyResponseType (ZPD-40)
	 */
	public void setEmergencyResponseType(String input) {
		setElement(input, 39);
	}

	/**
	 * EmergencyResponseType (ZPD-40)
	 * 
	 * @return value for EmergencyResponseType
	 */
	public String getEmergencyResponseType() {
		return getElement(39);
	}
}