/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A ZIE segment containing information Patient Ineligible Segment
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public class ZIE extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -3723659953669469756L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public ZIE() {
		super();
		setName(SegmentConstants.ZIE);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIE(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIE(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIE(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public ZIE(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * Sequential Number
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * INELIGIBLE DATE (.152)
	 * 
	 * @param input
	 *            A value of IneligibleDate
	 */
	public void setIneligibleDate(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * INELIGIBLE DATE (.152)
	 * 
	 * @return String A value of IneligibleDate
	 */
	public String getIneligibleDate() {
		return getElement(1);
	}

	/**
	 * 
	 * INELIGIBLE REASON (.307)
	 * 
	 * @param input
	 *            A value of IneligibleReason
	 */
	public void setIneligibleReason(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * INELIGIBLE REASON (.307)
	 * 
	 * @return String A value of IneligibleReason
	 */
	public String getIneligibleReason() {
		return getElement(2);
	}

	/**
	 * 
	 * INELIGIBLE VARO DECISION (.1656)
	 * 
	 * @param input
	 *            A value of IneligibleVaroDecision
	 */
	public void setIneligibleVaroDecision(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * INELIGIBLE VARO DECISION (.1656)
	 * 
	 * @return String A value of IneligibleVaroDecision
	 */
	public String getIneligibleVaroDecision() {
		return getElement(3);
	}

	/**
	 * 
	 * INELIGIBLE TWX CITY (.1653)
	 * 
	 * @param input
	 *            A value of IneligibleTwxCity
	 */
	public void setIneligibleTwxCity(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * INELIGIBLE TWX CITY (.1653)
	 * 
	 * @return String A value of IneligibleTwxCity
	 */
	public String getIneligibleTwxCity() {
		return getElement(4);
	}

	/**
	 * 
	 * INELIGIBLE TWX SOURCE (.1651)
	 * 
	 * @param input
	 *            A value of IneligibleTwxSource
	 */
	public void setIneligibleTwxSource(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * INELIGIBLE TWX SOURCE (.1651)
	 * 
	 * @return String A value of IneligibleTwxSource
	 */
	public String getIneligibleTwxSource() {
		return getElement(5);
	}

	/**
	 * 
	 * INELIGIBLE TWX STATE (.1654)
	 * 
	 * @param input
	 *            A value of IneligibleTwxState
	 */
	public void setIneligibleTwxState(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * INELIGIBLE TWX STATE (.1654)
	 * 
	 * @return String A value of IneligibleTwxState
	 */
	public String getIneligibleTwxState() {
		return getElement(6);
	}
}