/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.hl7.segment;

// Java classes
import java.util.List;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.constants.SegmentConstants;

/**
 * A PID segment containing information about a patient identification
 * 
 * @author DNS
 * @version 1.0
 */

public class PID extends Segment {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3304197612181844937L;

	/**
	 * Constructs an empty segment. This constructor is ususally usd by derived
	 * segment classes to populate its own segment data.
	 */
	public PID() {
		super();
		setName(SegmentConstants.PID);
	}

	/**
	 * Constructs a segment of elements from a raw data string. This constructor
	 * is usually used to construct an inbound message from a raw message's
	 * segment data.
	 * 
	 * @param data
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public PID(String data) throws InvalidSegmentException {
		super(data);
	}

	/**
	 * Constructs a segment of elements from a raw data string, an array of
	 * valid encoding character strings, and a element delimiter string. This
	 * constructor is usually used to construct an inbound message from a raw
	 * message's segment data, a specific encoding characters, and a field
	 * delimiter.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentData
	 *            A raw data string
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public PID(String[] encodingChars, String elementDelimiter, String segmentData)
			throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentData);
	}

	/**
	 * Constructs a segment from a segment name and a list of elements. This
	 * constructor is usually used to construct an outbound message from a list
	 * of specific segment elements, and a segment name.
	 * 
	 * @param name
	 *            A segment name
	 * @param elements
	 *            A list of segment elements
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public PID(String name, List elements) throws InvalidSegmentException {
		super(name, elements);
	}

	/**
	 * Constructs a segment from an array of encoding characters, a field
	 * delimiter, a segment name, and a list of field data. This constructor is
	 * usually used to construct an outbound message from a list of specific
	 * segment elements, element delimiter, and encoding characters.
	 * 
	 * @param encodingChars
	 *            An array of encoding characters
	 * @param elementDelimiter
	 *            A field delimiter
	 * @param segmentName
	 *            A segment name
	 * @param segmentElements
	 *            A list of field data
	 * @throws InvalidSegmentException
	 *             Thrown if failed to construct a segment due to missing
	 *             parameters or invalid segment data to parse.
	 */
	public PID(String[] encodingChars, String elementDelimiter, String segmentName,
			List segmentElements) throws InvalidSegmentException {
		super(encodingChars, elementDelimiter, segmentName, segmentElements);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER
	 * 
	 * @param input
	 *            A value of SetID
	 */
	public void setSetID(String input) {
		setElement(input, 0);
	}

	/**
	 * 
	 * SEQUENTIAL NUMBER
	 * 
	 * @return String A value of SetID
	 */
	public String getSetID() {
		return getElement(0);
	}

	/**
	 * 
	 * INTEGERATED CONTROL # (ICN) (991.01) and CHECKSUM (991.02) - ICN and �V�
	 * and Checksum
	 * 
	 * @param input
	 *            A value of PrimaryID
	 */
	public void setPrimaryID(String input) {
		setElement(input, 1);
	}

	/**
	 * 
	 * INTEGERATED CONTROL # (ICN) (991.01) and CHECKSUM (991.02) - ICN and �V�
	 * and Checksum
	 * 
	 * @return String A value of PrimaryID
	 */
	public String getPrimaryID() {
		return getElement(1);
	}

	/**
	 * 
	 * Will be in the format National ICN^SSN^ ALIASSSN^DFN^CLAIM#^Local ICN^
	 * Deprecated local ICN^Deprecated National ICN's and the format of each
	 * piece is Identifier~Assigning Authority~ Identifier type~Assigning
	 * Location~Expiration Date.
	 * 
	 * @param input
	 *            A value of InternalPatientID
	 */
	public void setPatientIdentifierList(String input) {
		setElement(input, 2);
	}

	/**
	 * 
	 * Will be in the format National ICN^SSN^ ALIASSSN^DFN^CLAIM#^Local ICN^
	 * Deprecated local ICN^Deprecated National ICN's and the format of each
	 * piece is Identifier~Assigning Authority~ Identifier type~Assigning
	 * Location~Expiration Date.
	 * 
	 * @return String A value of InternalPatientID
	 */
	public String getPatientIdentifierList() {
		return getElement(2);
	}

	/**
	 * 
	 * PRIMARY SHORT ID (.364) OR VA(�PID)
	 * 
	 * @param input
	 *            A value of AlternatePatientID
	 */
	public void setAlternatePatientID(String input) {
		setElement(input, 3);
	}

	/**
	 * 
	 * PRIMARY SHORT ID (.364) OR VA(�PID)
	 * 
	 * @return String A value of AlternatePatientID
	 */
	public String getAlternatePatientID() {
		return getElement(3);
	}

	/**
	 * 
	 * PATIENT NAME
	 * 
	 * @param input
	 *            A value of PatientName
	 */
	public void setPatientName(String input) {
		setElement(input, 4);
	}

	/**
	 * 
	 * PATIENT NAME
	 * 
	 * @return String A value of PatientName
	 */
	public String getPatientName() {
		return getElement(4);
	}

	/**
	 * 
	 * MOTHER�S MAIDEN NAME
	 * 
	 * @param input
	 *            A value of MotherMaidenName
	 */
	public void setMotherMaidenName(String input) {
		setElement(input, 5);
	}

	/**
	 * 
	 * MOTHER�S MAIDEN NAME
	 * 
	 * @return String A value of MotherMaidenName
	 */
	public String getMotherMaidenName() {
		return getElement(5);
	}

	/**
	 * 
	 * DATE OF BIRTH (.03) (Imprecise)
	 * 
	 * @param input
	 *            A value of DOB
	 */
	public void setDOB(String input) {
		setElement(input, 6);
	}

	/**
	 * 
	 * DATE OF BIRTH (.03) (Imprecise)
	 * 
	 * @return String A value of DOB
	 */
	public String getDOB() {
		return getElement(6);
	}

	/**
	 * 
	 * SEX (.02)
	 * 
	 * @param input
	 *            A value of Sex
	 */
	public void setSex(String input) {
		setElement(input, 7);
	}

	/**
	 * 
	 * SEX (.02)
	 * 
	 * @return String A value of Sex
	 */
	public String getSex() {
		return getElement(7);
	}

	/**
	 * 
	 * ALIAS (MULTIPLE 1, FIELD .01)
	 * 
	 * @param input
	 *            A value of PatientAlias
	 */
	public void setPatientAlias(String input) {
		setElement(input, 8);
	}

	/**
	 * 
	 * ALIAS (MULTIPLE 1, FIELD .01)
	 * 
	 * @return String A value of PatientAlias
	 */
	public String getPatientAlias() {
		return getElement(8);
	}

	/**
	 * 
	 * RACE
	 * 
	 * @param input
	 *            A value of Race
	 */
	public void setRace(String input) {
		setElement(input, 9);
	}

	/**
	 * 
	 * RACE
	 * 
	 * @return String A value of Race
	 */
	public String getRace() {
		return getElement(9);
	}

	/**
	 * 
	 * ADDRESS (.111-.116)
	 * 
	 * @param input
	 *            A value of PatientAddress
	 */
	public void setPatientAddress(String input) {
		setElement(input, 10);
	}

	/**
	 * 
	 * ADDRESS (.111-.116)
	 * 
	 * @return String A value of PatientAddress
	 */
	public String getPatientAddress() {
		return getElement(10);
	}

	/**
	 * 
	 * VA COUNTY CODE (.117)
	 * 
	 * @param input
	 *            A value of CountyCode
	 */
	public void setCountyCode(String input) {
		setElement(input, 11);
	}

	/**
	 * 
	 * VA COUNTY CODE (.117)
	 * 
	 * @return String A value of CountyCode
	 */
	public String getCountyCode() {
		return getElement(11);
	}

	/**
	 * 
	 * PHONE NUMBER (RESIDENCE) (.131)
	 * 
	 * @param input
	 *            A value of HomePhoneNumber
	 */
	public void setHomePhoneNumber(String input) {
		setElement(input, 12);
	}

	/**
	 * 
	 * PHONE NUMBER (RESIDENCE) (.131)
	 * 
	 * @return String A value of HomePhoneNumber
	 */
	public String getHomePhoneNumber() {
		return getElement(12);
	}

	/**
	 * 
	 * PHONE NUMBER (WORK) (.132)
	 * 
	 * @param input
	 *            A value of BusinessPhoneNumber
	 */
	public void setBusinessPhoneNumber(String input) {
		setElement(input, 13);
	}

	/**
	 * 
	 * PHONE NUMBER (WORK) (.132)
	 * 
	 * @return String A value of BusinessPhoneNumber
	 */
	public String getBusinessPhoneNumber() {
		return getElement(13);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of PrimaryLanguage
	 */
	public void setPrimaryLanguage(String input) {
		setElement(input, 14);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of PrimaryLanguage
	 */
	public String getPrimaryLanguage() {
		return getElement(14);
	}

	/**
	 * 
	 * MARITAL STATUS (.05)
	 * 
	 * @param input
	 *            A value of MaritalStatus
	 */
	public void setMaritalStatus(String input) {
		setElement(input, 15);
	}

	/**
	 * 
	 * MARITAL STATUS (.05)
	 * 
	 * @return String A value of MaritalStatus
	 */
	public String getMaritalStatus() {
		return getElement(15);
	}

	/**
	 * 
	 * RELIGION
	 * 
	 * @param input
	 *            A value of Religion
	 */
	public void setReligion(String input) {
		setElement(input, 16);
	}

	/**
	 * 
	 * RELIGION
	 * 
	 * @return String A value of Religion
	 */
	public String getReligion() {
		return getElement(16);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of PatientAccount
	 */
	public void setPatientAccount(String input) {
		setElement(input, 17);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of PatientAccount
	 */
	public String getPatientAccount() {
		return getElement(17);
	}

	/**
	 * 
	 * SOCIAL SECURITY NUMBER (.09)
	 * 
	 * @param input
	 *            A value of SSN
	 */
	public void setSSN(String input) {
		setElement(input, 18);
	}

	/**
	 * 
	 * SOCIAL SECURITY NUMBER (.09)
	 * 
	 * @return String A value of SSN
	 */
	public String getSSN() {
		return getElement(18);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @param input
	 *            A value of DriverLicenseNumber
	 */
	public void setDriverLicenseNumber(String input) {
		setElement(input, 19);
	}

	/**
	 * 
	 * NOT USED
	 * 
	 * @return String A value of DriverLicenseNumber
	 */
	public String getDriverLicenseNumber() {
		return getElement(19);
	}

}