/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
//Package
package gov.va.med.fw.hl7.constants;

/**
 * An interface containing all constants representing HL7 delimeters
 * 
 * @author Alex Yoon
 * @version 1.0
 */

public interface DelimeterConstants {
	/**
	 * Default encoding component delimiter
	 */
	public static final String DEFAULT_COMPONENT_DELIMITER = "~";

	/**
	 * Default encoding repeat delimiter
	 */
	public static final String DEFAULT_REPEAT_DELIMITER = "|";

	/**
	 * Default encoding escape delimiter
	 */
	public static final String DEFAULT_ESCAPE_DELIMITER = "\\";

	/**
	 * Default encoding subcomponent delimiter
	 */
	public static final String DEFAULT_SUBCOMPONENT_DELIMITER = "&";

	/**
	 * Default encoding field delimiter
	 */
	public static final String DEFAULT_FIELD_DELIMITER = "^";

	/**
	 * A default encoding element string "~|\&"
	 */
	public static final String DEFAULT_ENCODING_ELEMENT = (new StringBuilder(
			DEFAULT_COMPONENT_DELIMITER).append(DEFAULT_REPEAT_DELIMITER).append(
			DEFAULT_ESCAPE_DELIMITER).append(DEFAULT_SUBCOMPONENT_DELIMITER)).toString();

	/**
	 * A default encoding element array {"~","|","\\","&"}
	 */
	public static final String[] DEFAULT_ENCODERS = new String[] { DEFAULT_COMPONENT_DELIMITER,
			DEFAULT_REPEAT_DELIMITER, DEFAULT_ESCAPE_DELIMITER, DEFAULT_SUBCOMPONENT_DELIMITER };

}
