/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.hl7.builder;

// Java classes
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.hl7.BatchMessage;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.model.AbstractEntity;

/**
 * @author DNS
 * @version 1.0
 */
public class HL7MetaData extends AbstractMetaData {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8197192513563732428L;

	public HL7MetaData(AbstractEntity entity) {
		super(entity);
	}

	public HL7MetaData(Message message) {
		super(message);
	}

	public HL7MetaData(AbstractEntity entity, Message message) {
		super(entity, message);
	}

	public BatchMessage getBatchMessage() {
		Message msg = getMessage();
		if (logger.isDebugEnabled()) {
			logger.debug("Message: " + ToStringBuilder.reflectionToString(msg));
		}
		return (msg instanceof BatchMessage ? (BatchMessage) msg : null);
	}

	public Segment getSegment(String name) throws InvalidMessageException {
		return getMessage().getSegment(name);
	}

	public List getSegments(String name) throws InvalidMessageException {
		return getMessage().getSegments(name);
	}
}