package gov.va.med.fw.conversion;

import java.util.Map;

/**
 * This class models the input object for the BeanConverter.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
class ConversionRequest {
	protected Object source;
	protected Object target;

	protected Map sourceProperties;
	protected Map targetProperties;

	protected Map describedSource;

	/**
	 * Default converter to create the ConversionRequest.
	 */
	public ConversionRequest() {
	}

	/**
	 * Constructor to create the ConversionRequest object.
	 * 
	 * @param source
	 *            the source bean to copy the data from.
	 * @param sourceProperties
	 *            the property map for the source bean
	 * @param target
	 *            the target bean to copy the data to
	 * @param targetProperties
	 *            the property map for the target bean
	 */
	public ConversionRequest(Object source, Map sourceProperties, Object target,
			Map targetProperties) {
		this.source = source;
		this.target = target;
		this.sourceProperties = sourceProperties;
		this.targetProperties = targetProperties;
	}

	/**
	 * Getter for the source bean.
	 */
	public Object getSource() {
		return source;
	}

	/**
	 * Setter for the source bean.
	 */
	public void setSource(Object source) {
		this.source = source;
	}

	/**
	 * Getter for the source bean property map.
	 */
	public Map getSourceProperties() {
		return sourceProperties;
	}

	/**
	 * Setter for the source bean property map.
	 */
	public void setSourceProperties(Map sourceProperties) {
		this.sourceProperties = sourceProperties;
	}

	/**
	 * Getter for the target bean.
	 */
	public Object getTarget() {
		return target;
	}

	/**
	 * Setter for the target bean.
	 */
	public void setTarget(Object target) {
		this.target = target;
	}

	/**
	 * Getter for the target bean property map.
	 */
	public Map getTargetProperties() {
		return targetProperties;
	}

	/**
	 * Setter for the target bean property map.
	 */
	public void setTargetProperties(Map targetProperties) {
		this.targetProperties = targetProperties;
	}

	void setDescribedSource(Map describedSource) {
		this.describedSource = describedSource;
	}

	Map getDescribedSource() {
		return describedSource;
	}
}
