/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.cache;

import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Abstract managment of a cache. Implementation of cache is delegated to the
 * injected CacheStrategy.
 * 
 * Created Nov 3, 2005 12:25:34 PM
 * 
 * DNS
 */
public abstract class AbstractCacheManager extends AbstractComponent implements CacheManager {

	private static final long serialVersionUID = -1370346746640850300L;
	
	@Autowired
	@Qualifier("ehCacheStrategy")
	private CacheStrategy cacheStrategy;
	
	private boolean shouldCacheOutsideTransaction = false;

	public Object getItem(Object key) {
		return cacheStrategy.getItem(key);
	}

	public synchronized Object removeItem(Object key) {
		return cacheStrategy.removeItem(key);
	}

	public void cacheItem(Object key, Object value) {
		cacheStrategy.cacheItem(key, value);
	}

	public boolean containsItem(Object key) {
		return cacheStrategy.containsItem(key);
	}

	public void afterPropertiesSet() {
		Validate.notNull(cacheStrategy, "The cacheStrategy is null for " + getClass().getName());
	}

	/**
	 * @return Returns the cacheStrategy.
	 */
	public CacheStrategy getCacheStrategy() {
		return cacheStrategy;
	}

	/**
	 * @param cacheStrategy
	 *            The cacheStrategy to set.
	 */
	public void setCacheStrategy(CacheStrategy cacheStrategy) {
		this.cacheStrategy = cacheStrategy;
	}

	/**
	 * @param shouldCacheOutsideTransaction
	 *            The shouldCacheOutsideTransaction to set.
	 */
	public void setShouldCacheOutsideTransaction(boolean shouldCacheOutsideTransaction) {
		this.shouldCacheOutsideTransaction = shouldCacheOutsideTransaction;
	}

	protected boolean shouldCacheOutsideTransaction() {
		return shouldCacheOutsideTransaction;
	}
}
