/**
 * 
 */
package gov.va.med.fw.batchprocess;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

import gov.va.med.fw.service.ConfigurationConstants;
import gov.va.med.fw.service.jms.JMSPayload;
import gov.va.med.fw.service.jms.MessageProducerService;
import gov.va.med.fw.util.date.TimeZoneUtils;

/**
 * @author DNS
 * 
 */
public class ReportLauncherDetails extends QuartzJobBean {

	static final int MAX_USER_ID_LENGTH = 30;
	public static final String REPORT_SETUP_ID = "reportSetupId";

	private static Log log = LogFactory.getLog(JobLauncherDetails.class);
	private ApplicationContext applicationContext = null;
	private String jmsPayloadName;
	private String messageProducerServiceName = null;

	public ApplicationContext getApplicationContext() {
		return applicationContext;
	}

	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	public String getJmsPayloadName() {
		return jmsPayloadName;
	}

	public void setJmsPayloadName(String jmsPayloadName) {
		this.jmsPayloadName = jmsPayloadName;
	}

	public String getMessageProducerServiceName() {
		return messageProducerServiceName;
	}

	public void setMessageProducerServiceName(String messageProducerServiceName) {
		this.messageProducerServiceName = messageProducerServiceName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.springframework.scheduling.quartz.QuartzJobBean#executeInternal(org
	 * .quartz.JobExecutionContext)
	 */
	@Override
	protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
		Map jobDataMap = context.getJobDetail().getJobDataMap();

		Map<String, Object> map = new HashMap<String, Object>();
		map.put(REPORT_SETUP_ID, jobDataMap.get(REPORT_SETUP_ID));

		try {
			sendMessage(map, context.getJobDetail().getKey().getName());
		} catch (Exception e) {
			log.error("Could not execute job.", e);
		}
	}

	private void sendMessage(Map map, String userName) throws Exception {
		// Get the message producer service
		MessageProducerService messageProducerService = (MessageProducerService) getApplicationContext()
				.getBean(getMessageProducerServiceName());

		// get pay load bean
		JMSPayload jmsPayLoad = (JMSPayload) getApplicationContext().getBean(getJmsPayloadName());
		jmsPayLoad.setPayload((Serializable) map);

		// set header properties
		Map<String, Serializable> props = new HashMap<String, Serializable>();

		String logicalUserName = userName;
		if (logicalUserName.length() > MAX_USER_ID_LENGTH) {
			logicalUserName = logicalUserName.substring(0, MAX_USER_ID_LENGTH);
		}
		props.put(ConfigurationConstants.DEFAULT_MESSAGE_TYPE, jmsPayLoad
				.getTargetServiceDescriptor());
		props.put(ConfigurationConstants.DEFAULT_MESSAGE_INITIATER, logicalUserName);
		props.put(ConfigurationConstants.DEFAULT_MESSAGE_ORIGINATING_TIMEZONE, TimeZoneUtils.getTimeZone().getID());

		messageProducerService.send((Serializable) jmsPayLoad.getPayload(), props);
	}
}
