/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import java.util.List;
import java.util.Map;

import org.springframework.batch.core.BatchStatus;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.batchprocess.JobConfig;
import gov.va.med.fw.model.batchprocess.JobResult;
import gov.va.med.fw.model.batchprocess.JobStatus;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.scheduling.ScheduledProcessTriggerEvent;
import gov.va.med.fw.service.ServiceException;

/**
 * Initial javadoc for class BatchProcessService. TODO - Add content here
 * 
 * Created Sep 29, 2006 1:42:52 PM
 * 
 * DNS
 */
public interface BatchProcessService {
	
	public void saveJobResult(JobResult jr) throws ServiceException;

	public JobResultData saveAndOverlayJobResult(long id, ProcessStatistics stats,
			int totalDataCount) throws ServiceException;

	public JobResult getJobResult(final long id);

	public void saveJobConfig(JobConfig jc) throws ServiceException;

	public JobConfig getJobConfig(String jobName, String jobGroup) throws ServiceException;

	public List getJobResults(JobStatus status) throws ServiceException;

	public List getJobResults(BatchStatus status) throws ServiceException;

	public List getFinishedJobResults(String jobName, String jobGroup) throws ServiceException;

	public void executeJob(ScheduledProcessInvocationContext invocationContext)
			throws ServiceException;

	public void executeJob(ScheduledProcessTriggerEvent triggerEvent) throws ServiceException;

	public void executeJob(Map jobDetails) throws ServiceException;

	public void cancelActiveJob(long id) throws ServiceException;

	public void errActiveJob(long id);
}
