/********************************************************************
 * Copyriight 2006 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.batchprocess;

import java.util.Date;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.scheduling.TriggerStatus;

/**
 * Dynamic summary information about a batch process job.
 * 
 * Created Jun 26, 2006 1:17:01 PM
 * 
 * DNS
 */
public class BatchProcessDetailStatus extends AbstractEntity implements Comparable {

	private static final long serialVersionUID = -7440666543833035774L;
	private BatchProcessDetail batchProcessDetail;
	private TriggerStatus triggerStatus;
	private String emailDistributionList = null;

	/**
	 * @return Returns the batchProcessDetail.
	 */
	public BatchProcessDetail getBatchProcessDetail() {
		return batchProcessDetail;
	}

	/**
	 * @param batchProcessDetail
	 *            The batchProcessDetail to set.
	 */
	public void setBatchProcessDetail(BatchProcessDetail batchProcessDetail) {
		this.batchProcessDetail = batchProcessDetail;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang
	 * .builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		builder.append("batchProcessDetail", batchProcessDetail);
		builder.append("triggerStatus", triggerStatus);
	}

	/**
	 * @return Returns the triggerStatus.
	 */
	public TriggerStatus getTriggerStatus() {
		return triggerStatus;
	}

	/**
	 * @param triggerStatus
	 *            The triggerStatus to set.
	 */
	public void setTriggerStatus(TriggerStatus triggerStatus) {
		this.triggerStatus = triggerStatus;
	}

	public boolean isTriggerExist() {
		return triggerStatus != null && StringUtils.isNotBlank(triggerStatus.getStatus());
	}

	public boolean isActive() {
		return triggerStatus != null ? triggerStatus.isActive() : false;
	}

	public String getEmailDistributionList() {
		return emailDistributionList;
	}

	public void setEmailDistributionList(String emailDistributionList) {
		this.emailDistributionList = emailDistributionList;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		if (o instanceof BatchProcessDetailStatus) {
			BatchProcessDetailStatus other = (BatchProcessDetailStatus) o;
			Date otherDate = other.getTriggerStatus().getNextFireTime();
			Date myDate = triggerStatus.getNextFireTime();
			if (otherDate == null && myDate != null)
				return -1; // if other guy has no date, I should be deemed
			// before him
			if (otherDate == null && myDate == null)
				return 0;

			if (otherDate != null && myDate == null)
				return 1;
			return myDate.compareTo(otherDate);
		}
		return 1;
	}
}
