/**
 * 
 */
package gov.va.med.ccht.util;

import java.util.Calendar;
import java.util.Set;
import java.util.TimeZone;

import gov.va.med.ccht.model.Schedule;
import gov.va.med.ccht.model.terminology.DayOfMonth;
import gov.va.med.ccht.model.terminology.DayOfQuarter;
import gov.va.med.ccht.model.terminology.DayOfWeek;
import gov.va.med.ccht.model.terminology.RunFrequency;
import gov.va.med.ccht.model.terminology.ScheduleType;
import gov.va.med.ccht.model.terminology.WeekOfMonth;

/**
 * @author DNS
 *
 */
public class SchedulerUtils {
	
	/**
	 * Constants used to form a cron expression
	 */
	private static final String EMPTY_SPACE = " ";
	private static final String QUESTION_MARK = "?";
	
	public static String getCronExpression(Schedule schedule) {

		// Step 1: Persist a report set Already saved
		// reportDAO.saveReportSetup(setup);

		// Step 2: Build a cron expression is in this format
		// seconds + minutes + hours + day of month + month + day of
		// week + year
		String schedule_type = schedule.getScheduleType().getCode();
		String frequency = schedule.getRunFrequency().getCode();

		String second = "0";
		String dayOfWeek = null;
		String dayOfMonth = null;
		String month = null;
		String year = "*";

		int hour_val = schedule.getHour().intValue();
		String hour = String.valueOf(hour_val == 24 ? 0 : hour_val);
		String minute = String.valueOf(schedule.getMinute().intValue());

		// User selects daily/weekly
		if (RunFrequency.DAILY_WEEKLY.getCode().equals(frequency)) {
			Set<DayOfWeek> days = schedule.getDaysOfWeek();
			if (days != null)
				for (DayOfWeek dw : days) {
					if (dayOfWeek == null) {
						dayOfWeek = DayOfWeek.Code.getByCode(dw.getCode()).getAlias();
					} else {
						dayOfWeek += ("," + DayOfWeek.Code.getByCode(dw.getCode()).getAlias());
					}
				}
		}
		// User selects monthly
		else if (RunFrequency.MONTHLY.getCode().equals(frequency)) {
			// and last/first/15th date of a month
			if (ScheduleType.DAY_OF_MONTH.getCode().equals(schedule_type)) {
				dayOfMonth = DayOfMonth.Code.getByCode(schedule.getDayOfMonth().getCode())
						.getAlias();
			} else {
				// get week of month and day of month
				dayOfWeek = DayOfWeek.Code.getByCode(schedule.getDayOfWeek().getCode()).getAlias()
						+ WeekOfMonth.Code.getByCode(schedule.getWeekOfMonth().getCode())
								.getAlias();
			}
		}
		// User selects quarterly
		else if (RunFrequency.QUARTERLY.getCode().equals(frequency)) {
			DayOfQuarter dq = schedule.getDayOfQuarter();
			if (DayOfQuarter.CODE_FIRST.getCode().equals(dq.getCode())) {
				// First days of every quarter are 10/1, 1/1, 4/1, 7/1
				// (mm/dd)
				month = "1,4,7,10";
				dayOfMonth = "1";
			} else {
				// Last days of every quarter are 12/31, 3/31, 6/30,
				// 9/30 (mm/dd)
				month = "3,6,9,12";
				dayOfMonth = "L";
			}
		}
		// User selects yearly
		else if (RunFrequency.YEARLY.getCode().equals(frequency)) {
			// and day of month
			if (ScheduleType.WEEK_DAY_MONTH.getCode().equals(schedule_type)) {
				// get week of month
				// get day of week
				// get month
				dayOfWeek = DayOfWeek.Code.getByCode(schedule.getDayOfWeek().getCode()).getAlias()
						+ WeekOfMonth.Code.getByCode(schedule.getWeekOfMonth().getCode())
								.getAlias();
				month = schedule.getMonth().getCode();
			} else {
				month = schedule.getMonth().getCode();
				dayOfMonth = schedule.getNumericDayOfMonth().toString();
			}
		}
		// User selects other
		else if (RunFrequency.OTHER.getCode().equals(frequency)) {
			// get day to generate
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(schedule.getDateToGenerate().getDate());
			calendar.setTimeZone(TimeZone.getDefault()); //??schedule.getDateToGenerate().getTimeZone());
			year = String.valueOf(calendar.get(Calendar.YEAR));
			// Month starts with 0.
			month = String.valueOf(calendar.get(Calendar.MONTH) + 1);
			dayOfMonth = String.valueOf(calendar.get(Calendar.DAY_OF_MONTH));
		}

		// seconds + minutes + hours + day of month + month + day of
		// week + year
		StringBuilder cron = new StringBuilder();
		cron.append(second).append(EMPTY_SPACE).append(minute).append(EMPTY_SPACE).append(hour)
				.append(EMPTY_SPACE).append(dayOfMonth == null ? QUESTION_MARK : dayOfMonth)
				.append(EMPTY_SPACE).append(month == null ? "*" : month).append(EMPTY_SPACE)
				.append(dayOfWeek == null ? QUESTION_MARK : dayOfWeek).append(EMPTY_SPACE).append(
						year);
		return cron.toString();
	}
}
