package gov.va.med.ccht.ui.model;

import java.util.Date;
import java.util.List;

import gov.va.med.ccht.model.User;
import gov.va.med.fw.ui.model.Form;
import gov.va.med.fw.ui.model.TermType;

public class UserForm extends Form {
	
	private String userName;
	private String givenName;
	private String firstName;
	private String middleName;
	private String lastName;
	private String familyName;
	private String title;
	private String department;
	private String description;
	private String office;
	private String telephoneNumber;
	private String email;
	
	private TermType inactiveReason;
	private TermType registrationDeniedReason;
	private TermType registrationStatus;
	private TermType registrationReason;
	private TermType visn;
	private TermType facility;
	private TermType secondaryFacility;
	private TermType userGroup;
	private TermType vendor;
	private Boolean locked;
	private Boolean inactive;
	private Boolean isVendor;
	
	private Date accountExpireDate;
	private Date accountLockDate;
	private Date inactiveDate;
	private Date loginFailedDate;
	private Date lastLoginDate;
	private Short loginFailedCount;
		
	private String password;
	private List<TermType> roles;	
	private List<TermType> availableRoles;
	
	private String assignedRegistrationStatusId;
	private String jobDescriptionId;
	private String assignedUserGroup;
	private String assignedFacilityId;
	private String assignedVendorId;
	private String assignedVisnId;
	private String inactiveReasonId;
	private String inactivationDateAsString;
	private String returnPage;
	private String fromPage;
	private String registrationDeniedReasonId;
	
	private List<String> assignedRoles;
	
	private String[] assignedRolesArray;
	private String [] selectedRoles;
	
	//Preferences	
	private Boolean multipleWindows;
	
	
	
	public UserForm() {
		super();
	}
	public UserForm(User user) {
		super();		
	}	
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getGivenName() {
		return givenName;
	}
	public void setGivenName(String givenName) {
		this.givenName = givenName;
	}
	
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getMiddleName() {
		return middleName;
	}
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}
	
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getFamilyName() {
		return familyName;
	}
	public void setFamilyName(String familyName) {
		this.familyName = familyName;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getDepartment() {
		return department;
	}
	public void setDepartment(String department) {
		this.department = department;
	}
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		this.description = description;
	}
	public String getOffice() {
		return office;
	}
	public void setOffice(String office) {
		this.office = office;
	}
	public String getTelephoneNumber() {
		return telephoneNumber;
	}
	public void setTelephoneNumber(String telephoneNumber) {
		this.telephoneNumber = telephoneNumber;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public TermType getInactiveReason() {
		return inactiveReason;
	}
	public void setInactiveReason(TermType inactiveReason) {
		this.inactiveReason = inactiveReason;
	}
	public TermType getRegistrationStatus() {
		return registrationStatus;
	}
	public void setRegistrationStatus(TermType registrationStatus) {
		this.registrationStatus = registrationStatus;
	}
	public TermType getRegistrationDeniedReason() {
		return registrationDeniedReason;
	}
	public void setRegistrationDeniedReason(TermType registrationDeniedReason) {
		this.registrationDeniedReason = registrationDeniedReason;
	}

	public TermType getVisn() {
		return visn;
	}
	public void setVisn(TermType visn) {
		this.visn = visn;
	}
	public TermType getFacility() {
		return facility;
	}
	public void setFacility(TermType facility) {
		this.facility = facility;
	}
	public TermType getSecondaryFacility() {
		return secondaryFacility;
	}
	public void setSecondaryFacility(TermType secondaryFacility) {
		this.secondaryFacility = secondaryFacility;
	}
	public TermType getUserGroup() {
		return userGroup;
	}
	public void setUserGroup(TermType userGroup) {
		this.userGroup = userGroup;
	}
	
	public Boolean isVendor()
	{
		return isVendor;
	}
	
	public String getVendorName() {
		if(vendor != null)
		{			
			return vendor.getLabel();
		}
		else
		{			
			return null;
		}
	}
	
	public TermType getVendor() {
		return vendor;
	}
	
	
	public void setVendor(TermType vendor) {
		this.vendor = vendor;
	}
	public Date getAccountExpireDate() {
		return accountExpireDate;
	}
	public void setAccountExpireDate(Date accountExpireDate) {
		this.accountExpireDate = accountExpireDate;
	}
	public Date getAccountLockDate() {
		return accountLockDate;
	}
	public void setAccountLockDate(Date accountLockDate) {
		this.accountLockDate = accountLockDate;
	}
	public Date getInactiveDate() {
		return inactiveDate;
	}
	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}
	public Date getLoginFailedDate() {
		return loginFailedDate;
	}
	public void setLoginFailedDate(Date loginFailedDate) {
		this.loginFailedDate = loginFailedDate;
	}
	public Date getLastLoginDate() {
		return lastLoginDate;
	}
	public void setLastLoginDate(Date lastLoginDate) {
		this.lastLoginDate = lastLoginDate;
	}
	public Short getLoginFailedCount() {
		return loginFailedCount;
	}
	public void setLoginFailedCount(Short loginFailedCount) {
		this.loginFailedCount = loginFailedCount;
	}
	public TermType getRegistrationReason() {
		return registrationReason;
	}
	public void setRegistrationReason(TermType registrationReason) {
		this.registrationReason = registrationReason;
	}	
	public String getPassword() {
		return password;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	
	public String getRolesAsString() {
		
		String retVal = "";
		
		retVal += ((TermType)roles.get(0)).getValue();
		for (int index = 1; index< roles.size(); index++) {
			retVal += ", " + ((TermType)roles.get(index)).getValue();
		} 
		
		return retVal;
	}
	public List<TermType> getRoles() {
		return roles;
	}
	public void setRoles(List<TermType> roles) {
		this.roles = roles;
	}
	public List<TermType> getAvailableRoles() {
		return availableRoles;
	}
	public void setAvailableRoles(List<TermType> availableRoles) {
		this.availableRoles = availableRoles;
	}
	public String toString() { 
		return getUserName();
	}
	public Boolean getLocked() {
		return locked;
	}
	public void setLocked(Boolean locked) {
		this.locked = locked;
	}
	public Boolean getInactive() {
		return inactive;
	}
	public void setInactive(Boolean inactive) {
		this.inactive = inactive;
	}
	public Boolean getMultipleWindows() {
		return multipleWindows;
	}
	public void setMultipleWindows(Boolean multipleWindows) {
		this.multipleWindows = multipleWindows;
	}
	public String getAssignedUserGroup() {
		return assignedUserGroup;
	}
	public void setAssignedUserGroup(String assignedUserGroup) {
		this.assignedUserGroup = assignedUserGroup;
	}
	public Boolean getIsVendor() {
		return isVendor;
	}
	public void setIsVendor(Boolean isVendor) {
		this.isVendor = isVendor;
	}
	public String getAssignedFacilityId() {
		return assignedFacilityId;
	}
	public void setAssignedFacilityId(String assignedFacilityId) {
		this.assignedFacilityId = assignedFacilityId;
	}
	public String getAssignedVendorId() {
		return assignedVendorId;
	}
	public void setAssignedVendorId(String assignedVendorId) {
		this.assignedVendorId = assignedVendorId;
	}
	public String getAssignedRegistrationStatusId() {
		return assignedRegistrationStatusId;
	}
	public void setAssignedRegistrationStatusId(String assignedRegistrationStatusId) {
		this.assignedRegistrationStatusId = assignedRegistrationStatusId;
	}
	public String getJobDescriptionId() {
		return jobDescriptionId;
	}
	public void setJobDescriptionId(String jobDescriptionId) {
		this.jobDescriptionId = jobDescriptionId;
	}
	public String getAssignedVisnId() {
		return assignedVisnId;
	}
	public void setAssignedVisnId(String assignedVisnId) {
		this.assignedVisnId = assignedVisnId;
	}
	public String getInactiveReasonId() {
		return inactiveReasonId;
	}
	public void setInactiveReasonId(String inactiveReasonId) {
		this.inactiveReasonId = inactiveReasonId;
	}
	public List<String> getAssignedRoles() {
		return assignedRoles;
	}
	public void setAssignedRoles(List<String> assignedRoles) {
		this.assignedRoles = assignedRoles;
	}
	public String getInactivationDateAsString() {
		return inactivationDateAsString;
	}
	public void setInactivationDateAsString(String inactivationDateAsString) {
		this.inactivationDateAsString = inactivationDateAsString;
	}
	public Boolean isLocked() {
		return locked;
	}
	public Boolean isInactive() {
		return inactive;
	}
	public String getReturnPage() {
		return returnPage;
	}
	public void setReturnPage(String returnPage) {
		this.returnPage = returnPage;
	}
	public String getFromPage() {
		return fromPage;
	}
	public void setFromPage(String fromPage) {
		this.fromPage = fromPage;
	}
	public String getRegistrationDeniedReasonId() {
		return registrationDeniedReasonId;
	}
	public void setRegistrationDeniedReasonId(String registrationDeniedReasonId) {
		this.registrationDeniedReasonId = registrationDeniedReasonId;
	}
	public String[] getAssignedRolesArray() {
		return assignedRolesArray;
	}
	public void setAssignedRolesArray(String[] assignedRolesArray) {
		this.assignedRolesArray = assignedRolesArray;
	}
	public String[] getSelectedRoles() {
		return selectedRoles;
	}
	public void setSelectedRoles(String[] selectedRoles) {
		this.selectedRoles = selectedRoles;
	}
	
	

}