package gov.va.med.ccht.ui.model;

import java.util.List;

import gov.va.med.ccht.model.User;
import gov.va.med.fw.ui.model.TermType;

public class DmpAssignee {

	private Boolean  isAssigned = false;
	
	private UserForm userForm;
	private String dmpRole="";
	private String visnFacility="";
	private User user;
	private boolean assigned;
	private boolean disableNewUserAssignment;
	private String dmpToolUserId;

	private boolean reviewer;
	private boolean disableNewUserReviewerAssignment;
	
	public String getDmpRole() {
		return dmpRole;
	}

	public void setDmpRole(String dmpRole) {
		this.dmpRole = dmpRole;
	}

	public UserForm getUserForm() {
		return userForm;
	}

	public void setUserForm(UserForm userForm) {
		this.userForm = userForm;
		List<TermType> roles = this.userForm.getRoles();
		int count=0;
		for(TermType role:  roles)
		{
			if(role.getLabel().indexOf("DMP")!=-1)
			{
				if(count==0)
				{
				  dmpRole=role.getLabel();
				}
				else
				{
					dmpRole=dmpRole+", "+ role.getLabel();
				}
				count++;
			}
		}
		if(dmpRole.length()<3)
		{
			dmpRole="DMP Role not assigned";
			setDisableNewUserAssignment(true);
			this.setDisableNewUserReviewerAssignment(true);
		}
			
	}

	public String getVisnFacility() {
		String visnLabel = null;
		String facilityLabel = null;
		if (userForm.getVisn() == null) {
			visnLabel = "";
		}
		else {
			visnLabel = userForm.getVisn().getLabel() == null ? "" : userForm.getVisn().getLabel().trim();
		}
		if (userForm.getFacility() == null) {
			facilityLabel = "";
		}
		else {
			facilityLabel = userForm.getFacility().getLabel() == null ? "" : userForm.getFacility().getLabel().trim();
		}
		
		if (visnLabel.length() == 0 && facilityLabel.length() == 0) {
			visnFacility = "";
		}
		else if (visnLabel.length() == 0 && facilityLabel.length() > 0) {
			visnFacility = facilityLabel;
		} else if (visnLabel.length() > 0 && facilityLabel.length() == 0) {
			visnFacility = visnLabel;
		} else {
			visnFacility = visnLabel + " / " + facilityLabel;
		}
		return visnFacility;
	}

	public void setVisnFacility(String visnFacility) {
		this.visnFacility = visnFacility;
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

	public Boolean getIsAssigned() {
		return isAssigned;
	}

	public void setIsAssigned(Boolean isAssigned) {
		this.isAssigned = isAssigned;
	}

	public boolean isAssigned() {
		return assigned;
	}

	public void setAssigned(boolean assigned) {
		this.assigned = assigned;
	}

	public boolean isDisableNewUserAssignment() {
		return disableNewUserAssignment;
	}

	public void setDisableNewUserAssignment(boolean disableNewUserAssignment) {
		this.disableNewUserAssignment = disableNewUserAssignment;
	}

	public String getDmpToolUserId() {
		return dmpToolUserId;
	}

	public void setDmpToolUserId(String dmpToolUserId) {
		this.dmpToolUserId = dmpToolUserId;
	}

	public boolean isReviewer() {
		return reviewer;
	}

	public void setReviewer(boolean reviewer) {
		this.reviewer = reviewer;
	}
	
	public boolean getReviewer() {
		return reviewer;
	}

	public boolean isDisableNewUserReviewerAssignment() {
		return disableNewUserReviewerAssignment;
	}

	public void setDisableNewUserReviewerAssignment(
			boolean disableNewUserReviewerAssignment) {
		this.disableNewUserReviewerAssignment = disableNewUserReviewerAssignment;
	}
	
}
