/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.ui.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.fw.ui.model.Form;
import gov.va.med.fw.ui.model.TermType;

/**
 * @author DNS
 */
public class CompletedReportUniqueFilterValuesForm extends Form {

	private String fieldName;
	private List<TermType> values;

	public CompletedReportUniqueFilterValuesForm(String fieldName,
			LinkedHashMap<String, String> uniqueVals) {
		this.fieldName = fieldName;
		this.values = new ArrayList<TermType>(uniqueVals.size());
		for (Map.Entry<String, String> entry : uniqueVals.entrySet()) {
			values.add(new TermType(entry.getValue(), entry.getKey()));
		}
	}

	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	public List<TermType> getValues() {
		return values;
	}

	public void setValues(List<TermType> values) {
		this.values = values;
	}

}
