/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.ui.model;

import java.util.Calendar;
import java.util.GregorianCalendar;

import gov.va.med.fw.ui.model.Form;
import gov.va.med.fw.ui.model.TermType;

/**
 * 
 * 
 * IHTA ohrs_web Aug 25, 2010
 * 
 * @author DNS
 */
public class CompletedReportForm extends Form {
	private StandardReportForm standardReport;
	private FormattedDateForm completedDate;
	private TermType fileType;
	private String reportParameterText;
	private FormattedDateForm expirationDate;
	private String userName;
	private String userFullName;
	private TermType reportFormat;
	private String reportName;
	private boolean reportExtendable = false;

	// report file blob
	// private byte[] reportFileContent;
	public FormattedDateForm getCompletedDate() {
		return completedDate;
	}

	public void setCompletedDate(FormattedDateForm completedDate) {
		this.completedDate = completedDate;
	}

	public TermType getFileType() {
		return fileType;
	}

	public void setFileType(TermType fileType) {
		this.fileType = fileType;
	}

	public String getReportParameterText() {
		return reportParameterText;
	}

	public void setReportParameterText(String reportParameterText) {
		this.reportParameterText = reportParameterText;
	}

	public StandardReportForm getStandardReport() {
		return standardReport;
	}

	public void setStandardReport(StandardReportForm standardReport) {
		this.standardReport = standardReport;
	}

	public FormattedDateForm getExpirationDate() {
		return expirationDate;
	}

	public void setExpirationDate(FormattedDateForm expirationDate) {
		this.expirationDate = expirationDate;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserFullName() {
		return userFullName;
	}

	public void setUserFullName(String userFullName) {
		this.userFullName = userFullName;
	}

	public TermType getReportFormat() {
		return reportFormat;
	}

	public void setReportFormat(TermType reportFormat) {
		this.reportFormat = reportFormat;
	}

	public String getReportName() {
		return reportName;
	}

	public void setReportName(String reportName) {
		this.reportName = reportName;
	}

	public boolean isReportExtendable() {
		GregorianCalendar gced = new GregorianCalendar();
		gced.setTime(this.expirationDate.getDate());
		GregorianCalendar gc = new GregorianCalendar();
		gc.roll(Calendar.YEAR, 1);
		if(gced.getTime().before(gc.getTime()))
		{
			if(gced.get(Calendar.YEAR)!=gc.get(Calendar.YEAR))
			{
				reportExtendable=true;
			}
			else if(gced.get(Calendar.MONTH)!=gc.get(Calendar.MONTH))
			{
				reportExtendable=true;
			}
			else if(gced.get(Calendar.DAY_OF_MONTH)!=gc.get(Calendar.DAY_OF_MONTH))
			{
				reportExtendable=true;
			}				
		}
		return reportExtendable;
	}

	public void setReportExtendable(boolean reportExtendable) {
		this.reportExtendable = reportExtendable;
	}
}
