/**
 * 
 */
package gov.va.med.ccht.ui.model;

import java.text.SimpleDateFormat;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;

import gov.va.med.fw.ui.model.Form;

@JsonAutoDetect(fieldVisibility = Visibility.NONE, getterVisibility = Visibility.PUBLIC_ONLY, isGetterVisibility = Visibility.PUBLIC_ONLY)
public class BatchProcessDetailForm extends Form implements Comparable<BatchProcessDetailForm> {

	private String jobName;
	private String jobDescription;
	private String jobSchedule;
	private String jobScheduleDescription;
	private String triggerName;
	private String triggerGroup;
	private String groupName;
	private String emailDistributionList;
	private String status; // trigger status
	private String previousTriggerStatus;
	private String nextFireTime; // includes timezone information
	private ReportScheduleForm reportSchedule;

	public static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z");
	
	public String getEmailDistributionList() {
		return emailDistributionList;
	}

	public void setEmailDistributionList(String emailDistributionList) {
		this.emailDistributionList = emailDistributionList;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	public String getJobDescription() {
		return jobDescription;
	}

	public void setJobDescription(String jobDescription) {
		this.jobDescription = jobDescription;
	}

	public String getJobName() {
		return jobName;
	}

	public void setJobName(String jobName) {
		this.jobName = jobName;
	}

	public String getNextFireTime() {
		return nextFireTime;
	}

	public void setNextFireTime(Date date) {
		this.nextFireTime = formatter.format(date);
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getTriggerGroup() {
		return triggerGroup;
	}

	public void setTriggerGroup(String triggerGroup) {
		this.triggerGroup = triggerGroup;
	}

	public String getTriggerName() {
		return triggerName;
	}

	public void setTriggerName(String triggerName) {
		this.triggerName = triggerName;
	}

	public String getJobSchedule() {
		return jobSchedule;
	}

	public void setJobSchedule(String jobSchedule) {
		this.jobSchedule = jobSchedule;
	}

	public String getPreviousTriggerStatus() {
		return previousTriggerStatus;
	}

	public void setPreviousTriggerStatus(String previousTriggerStatus) {
		this.previousTriggerStatus = previousTriggerStatus;
	}

	public String getJobScheduleDescription() {
		return jobScheduleDescription;
	}

	public void setJobScheduleDescription(String jobScheduleDescription) {
		this.jobScheduleDescription = jobScheduleDescription;
	}

	public ReportScheduleForm getReportSchedule() {
		return reportSchedule;
	}

	public void setReportSchedule(ReportScheduleForm reportSchedule) {
		this.reportSchedule = reportSchedule;
	}

	public int compareTo(BatchProcessDetailForm other) {
		if (other == null)
			return -1;

		if (getJobName() == null) {
			return 1;
		}

		if (other.getJobName() == null) {
			return -1;
		}
		// compare by name
		return getJobName().compareToIgnoreCase(other.getJobName());
	}
}
