package gov.va.med.ccht.ui.common;


public class ControllerException extends Exception {

	private static final long serialVersionUID = 50518978290246780L;

	private String exceptionId;
	private ControllerResult callStatus;

	public ControllerException() {
		super();
	}

	public ControllerException(String msg) {
		super(msg);
	}

	public ControllerException(String msg, String exceptionId) {
		super(msg);
		this.exceptionId = exceptionId;
	}

	public ControllerException(Throwable cause) {
		super(cause);
	}

	public ControllerException(Throwable cause, String exceptionId) {
		super(cause);
		this.exceptionId = exceptionId;
	}

	public ControllerException(String msg, Throwable cause) {
		super(msg, cause);
	}

	public ControllerException(String msg, Throwable cause, String exceptionId) {
		super(msg, cause);
		this.exceptionId = exceptionId;
	}

	public String getExceptionId() {
		return exceptionId;
	}

	public void setExceptionId(String exceptionId) {
		this.exceptionId = exceptionId;
	}

	public ControllerResult getCallStatus() {
		return callStatus;
	}

	public void setCallStatus(ControllerResult callStatus) {
		this.callStatus = callStatus;
	}

	@Override
	public String getMessage() {
		String msg = super.getMessage();
		return msg != null ? msg + "\n" + getDetailedMessage() : msg;
	}

	protected String getDetailedMessage() {
		StackTraceElement[] trace = getStackTrace();
		StringBuilder stackTrace = new StringBuilder();
		if (stackTrace != null) {
			for (int i = 0; i < trace.length; i++) {
				if (trace[i] != null) {
					stackTrace.append(trace[i].toString());
					stackTrace.append("\n");
				}
			}
		}

		Throwable ourCause = getCause();
		while (ourCause != null) {
			if (ourCause != null) {
				stackTrace.append(ourCause.getMessage() + "\n");
				ourCause = ourCause.getCause();
			}
		}
		return stackTrace.toString();
	}
}
