package gov.va.med.ccht.ui.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.ccht.service.common.SecurityService;
import gov.va.med.ccht.service.common.TerminologyCache;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.service.common.facility.FacilityService;
import gov.va.med.ccht.service.common.reports.ReportService;
import gov.va.med.ccht.service.common.vendor.VendorService;
import gov.va.med.ccht.service.common.visn.VisnService;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.ui.model.TermType;


public class AbstractConversionService  {

	@Autowired
	private TerminologyCache terminologyCache;
	@Autowired
	private ReportService reportService;
	@Autowired
	private VisnService visnService;
	@Autowired
	private FacilityService facilityService;
	@Autowired
	private VendorService vendorService;
	@Autowired
	private SecurityService securityService; 

	public <T extends Lookup> T getByCode(Class<T> terminologyType, String code)
			throws TerminologyException {
		return terminologyCache.getTermByCode(terminologyType, code);
	}

	public <T extends Lookup> T getByName(Class<T> terminologyType, String name)
			throws TerminologyException {
		return terminologyCache.getTermByName(terminologyType, name);
	}

	public <T extends Lookup> T getById(Class<T> terminologyType, Long id)
			throws TerminologyException {
		return terminologyCache.getTermById(terminologyType, id);
	}

	public <T extends Lookup> List<T> findAll(Class<T> terminologyType) throws TerminologyException {
		return terminologyCache.getTerms(terminologyType);
	}

	public List<TermType> toTermTypeList(Set<? extends Lookup> lookups) {
		List<TermType> termTypes = new ArrayList<TermType>();
		if (lookups != null && lookups.size() > 0) {
			for (Lookup lookup : lookups) {
				if (lookup != null)
					termTypes.add(new TermType(lookup.getName(), lookup.getCode()));
			}
		}
		Collections.sort(termTypes);
		return termTypes;
	}

	public List<TermType> toTermTypeListFromValues(Set<String> values) {
		List<TermType> termTypes = new ArrayList<TermType>();
		if (values != null && values.size() > 0) {
			for (String value : values) {
				termTypes.add(new TermType(value, value));
			}
		}
		return termTypes;
	}

	public TermType toTermType(Lookup lookup) {
		return lookup != null ? new TermType(lookup.getName(), lookup.getCode()) : null;
	}

	public <T extends Lookup> T getLookup(Class<T> terminologyType, TermType termType)
		throws TerminologyException { 
		return (termType != null) ? 
				terminologyCache.getTermByCode(terminologyType, termType.getValue()) : null;
	}
	
	public SimpleFacility getFacility(TermType termType) throws TerminologyException {
		try {
			return (termType != null) ? 
				facilityService.getSimpleFacility(termType.getValue()) : null;
		}catch (ServiceException e){
			throw new TerminologyException("inventoryService.getFacility failed");
		}
	}
	
	public SimpleVisn getVisn(TermType termType) throws TerminologyException { 
		try {
			return (termType != null) ? 
				visnService.getSimpleVisn(termType.getValue()) : null;
		}catch (Exception e){
			throw new TerminologyException("inventoryService.getSimpleVisn failed");
		}
	}
	
	public Role getRole(TermType termType) throws TerminologyException {
		try {
			return (termType != null) ? 
					securityService.getRole(termType.getValue()) : null;
		}catch (Exception e){
			throw new TerminologyException("securityService.getRole failed");
		}
	}
	
	public Vendor getVendor(TermType termType) throws TerminologyException {
		try {			
			return (termType != null) ? vendorService.getVendor(termType.getLabel()) : null;
		}catch (ServiceException e){
			throw new TerminologyException("inventoryService.getFacility failed");
		}
	}
	
	public TerminologyCache getTerminologyCache() {
		return terminologyCache;
	}

	public void setTerminologyCache(TerminologyCache terminologyCache) {
		this.terminologyCache = terminologyCache;
	}	

	public ReportService getReportService() {
		return reportService;
	}

	public void setReportService(ReportService reportService) {
		this.reportService = reportService;
	}

	public VisnService getVisnService() {
		return visnService;
	}

	public void setVisnService(VisnService visnService) {
		this.visnService = visnService;
	}

	public FacilityService getFacilityService() {
		return facilityService;
	}

	public void setFacilityService(FacilityService facilityService) {
		this.facilityService = facilityService;
	}

	public VendorService getVendorService() {
		return vendorService;
	}

	public void setVendorService(VendorService vendorService) {
		this.vendorService = vendorService;
	}

	public SecurityService getSecurityService() {
		return securityService;
	}

	public void setSecurityService(SecurityService securityService) {
		this.securityService = securityService;
	}

	public Map<String, AbstractKeyedEntity> getMapFromCollection(
			Set<? extends AbstractKeyedEntity> set) {
		Map<String, AbstractKeyedEntity> map = new HashMap<String, AbstractKeyedEntity>();
		if (set != null) {
			for (AbstractKeyedEntity keyedEntity : set) {
				map.put(keyedEntity.getEntityKey().getKeyValueAsString(), keyedEntity);
			}
		}
		return map;
	}

	protected UserPrincipal getCurrentUser() {
		SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
		return securityContext.getUserPrincipal();
	}
	
}